/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program;

import net.comp_lot.craftalos.system.EditHistory;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.TextInput;

class BlockTextInput
extends TextInput {
    private final ProgramBlock block;
    private final int slot;
    private final EditHistory<String> hist;

    public BlockTextInput(ProgramBlock block, Label label) {
        super(null);
        this.block = block;
        this.slot = block.getLabelIndex(label);
        block.checkInputRule(this.slot, true);
        this.enableCandidates(block.getCandidatesFunction(this.slot));
        this.hist = new EditHistory<String>(block.getValue(this.slot));
        this.setCursor(Integer.MAX_VALUE);
    }

    @Override
    protected void setText(String s) {
        this.block.setValue(this.slot, s);
        this.block.checkInputRule(this.slot, true);
        this.hist.addHistory(s);
    }

    @Override
    protected String getText() {
        return this.block.getValue(this.slot);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.block.checkInputRule(this.slot, false);
    }

    @Override
    public Label getLabel() {
        return this.block.getLabel(this.slot);
    }

    public void undo() {
        this.block.setValue(this.slot, this.hist.undo());
        this.block.checkInputRule(this.slot, true);
    }

    public void redo() {
        this.block.setValue(this.slot, this.hist.redo());
        this.block.checkInputRule(this.slot, true);
    }
}

