/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.craftalos.program.compiler.ProgramCompiler;
import net.comp_lot.craftalos.system.network.CongestionControl;
import net.comp_lot.craftalos.system.network.Connection;
import net.comp_lot.craftalos.system.network.data.ControlDataCache;
import net.comp_lot.craftalos.system.network.data.WorldData;
import net.comp_lot.craftalos.system.network.data.WorldDataCache;
import net.comp_lot.craftalos.system.network.server.AbstractServer;
import net.comp_lot.glui.amount.Vector;

class PlayerConnection {
    private final AbstractServer server;
    private final Connection socket;
    private int worldDataVersion;
    private WorldDataCache worldData;
    private ControlDataCache controlData;
    private final String bcm;
    private final String bcp;
    private boolean running = true;
    private final CongestionControl congestionControl = new CongestionControl(60);
    private volatile boolean sendModelHost = false;
    private final List<String> textQueue = new ArrayList<String>();

    public PlayerConnection(Connection socket, AbstractServer server) throws IOException, CompileException {
        this.socket = socket;
        this.server = server;
        this.bcm = socket.ois.readUTF();
        this.bcp = socket.ois.readUTF();
        this.checkMachine();
    }

    public String getBcm() {
        return this.bcm;
    }

    public String getBcp() {
        return this.bcp;
    }

    public void sendJoinState(String state, int id) throws IOException {
        this.socket.oos.writeUTF(state);
        this.socket.oos.writeInt(id);
        this.socket.oos.flush();
    }

    public void sendInitialCamera(Vector camera) throws IOException {
        camera.write(this.socket.oos);
        this.socket.oos.flush();
    }

    private void checkMachine() throws IOException, CompileException {
        try {
            MachineCompiler.compile(this.bcm);
        }
        catch (CompileException e) {
            this.socket.oos.writeUTF(e.getDetailMessage(this.bcm));
            this.socket.oos.flush();
            throw e;
        }
        try {
            ProgramCompiler.compile(this.bcp);
        }
        catch (CompileException e) {
            this.socket.oos.writeUTF(e.getDetailMessage(this.bcp));
            this.socket.oos.flush();
            throw e;
        }
        this.socket.oos.writeUTF("Machine compile OK");
        this.socket.oos.writeUTF("Program compile OK");
        this.socket.oos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String text) {
        List<String> list = this.textQueue;
        synchronized (list) {
            this.textQueue.add(text);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
        this.socket.close();
    }

    public void updateModelHost() {
        if (!this.running) {
            return;
        }
        this.sendModelHost = true;
        this.worldDataVersion -= 1000;
        this.server.getWorldData().accept(wd -> wd.notifyAll());
        while (this.sendModelHost && this.running) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.sendModelHost = false;
    }

    public void setId(int id, int machineId) {
        this.worldData = new WorldDataCache(id, machineId);
        this.controlData = new ControlDataCache(id);
    }

    public void start() {
        new Thread(this::sendLoop, "CT Server Player Send").start();
        new Thread(this::receiveLoop, "CT Server Player Receive").start();
    }

    private void sendLoop() {
        while (this.running) {
            try {
                this.server.getWorldData().accept(wd -> {
                    if (wd.getCnt() == this.worldDataVersion) {
                        if (this.sendModelHost) {
                            return;
                        }
                        wd.wait();
                    }
                    this.worldData.copy((WorldData)wd);
                });
                if (this.congestionControl.send() || this.sendModelHost) {
                    this.socket.oos.writeByte(this.congestionControl.getSendCount());
                    this.worldDataVersion = this.worldData.getCnt();
                    this.sendModelHost();
                    this.writeWorldData();
                    this.sendText();
                    this.socket.oos.writeUTF("end");
                    this.socket.oos.flush();
                    this.socket.oos.reset();
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (IOException | InterruptedException e) {
                this.running = false;
            }
        }
        this.sendModelHost = false;
        this.socket.close();
        this.server.removePlayer();
    }

    private void writeWorldData() throws IOException {
        this.socket.oos.writeUTF("wrd");
        this.worldData.write(this.socket.oos);
    }

    private void sendModelHost() throws IOException {
        if (this.sendModelHost) {
            this.socket.oos.writeUTF("mdl");
            this.socket.oos.writeObject(this.server.getModel());
            this.sendModelHost = false;
            this.worldData.getCSList().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendText() throws IOException {
        List<String> list = this.textQueue;
        synchronized (list) {
            for (String s : this.textQueue) {
                this.socket.oos.writeUTF("txt");
                this.socket.oos.writeUTF(s);
            }
            this.textQueue.clear();
        }
    }

    private void receiveLoop() {
        while (this.running) {
            try {
                this.congestionControl.acknowledge(this.socket.ois.readByte());
                this.controlData.getKeyState().get(0).read(this.socket.ois);
                this.controlData.getCamerasAxis().get(0).read(this.socket.ois);
            }
            catch (IOException e) {
                this.running = false;
            }
            this.server.getControlData().accept(cd -> cd.copy(this.controlData));
        }
    }
}

