/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network.server;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.system.network.Connection;
import net.comp_lot.craftalos.system.network.LocalConnection;
import net.comp_lot.craftalos.system.network.SocketConnection;
import net.comp_lot.craftalos.system.network.data.RoomInformation;
import net.comp_lot.craftalos.system.network.server.GameServer;
import net.comp_lot.craftalos.system.title.RoomConfig;

public class LobbyServer {
    private final boolean log;
    private volatile boolean running = true;
    private final ServerSocket ss;
    private final Map<String, GameServer> servers = new HashMap<String, GameServer>();
    private long roomsLastUpdatedTime = System.currentTimeMillis();
    private final List<RoomInformation> rooms = new ArrayList<RoomInformation>();

    public LobbyServer(int port, boolean ssl, boolean log) {
        this.log = log;
        ServerSocket ss = null;
        try {
            ss = LobbyServer.getServerSocket(port, ssl);
            ss.setSoTimeout(1000);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
        this.ss = ss;
        new Thread(this::waitClient, "CT Lobby Clerk").start();
    }

    public LobbyServer() {
        this.log = true;
        this.ss = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.running = false;
        Map<String, GameServer> map = this.servers;
        synchronized (map) {
            this.servers.values().parallelStream().forEach(s -> s.stop());
        }
    }

    private void waitClient() {
        try {
            if (this.log) {
                System.out.println("Lobby start at " + this.ss.getLocalPort());
            }
            while (this.running) {
                try {
                    Socket s = this.ss.accept();
                    SocketConnection socket = SocketConnection.open(s, true);
                    new Thread(() -> this.accept(socket), "CT Lobby Accept").start();
                }
                catch (IOException s) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    private static ServerSocket getServerSocket(int port, boolean ssl) throws Exception {
        if (ssl) {
            FileInputStream p12_file = new FileInputStream(Main.certFile);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("NewSunX509");
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(p12_file, Main.certPass);
            kmf.init(ks, Main.certPass);
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(kmf.getKeyManagers(), null, null);
            return sc.getServerSocketFactory().createServerSocket(port);
        }
        return new ServerSocket(port);
    }

    public int getPort() {
        return this.ss.getLocalPort();
    }

    public Connection acceptLocal() throws IOException {
        LocalConnection[] connection = LocalConnection.open();
        new Thread(() -> this.accept(connection[0])).start();
        return connection[1];
    }

    private void accept(Connection socket) {
        try {
            String[] agentAry;
            String agent = socket.ois.readUTF();
            if (this.log) {
                System.out.println(agent + " : " + socket.getInetAddress());
            }
            if ((agentAry = agent.split(" ")).length < 2) {
                System.err.println("Version not found : " + agent);
                socket.close("Version not found : " + agent);
                return;
            }
            String[] version = agentAry[1].split("\\.");
            String[] hostVersion = "\u03b21.5.0".split("\\.");
            if (version.length < 3 || !version[0].equals(hostVersion[0]) || !version[1].equals(hostVersion[1])) {
                System.err.println(String.format("%s is not compatible with %s", agentAry[1], "\u03b21.5.0"));
                socket.close(String.format("%s is not compatible with %s", agentAry[1], "\u03b21.5.0"));
                return;
            }
            switch (agentAry[0]) {
                case "host": {
                    this.addHost(socket);
                    break;
                }
                case "guest": {
                    this.addGuest(socket);
                    break;
                }
                case "lobby": {
                    this.sendLobbyInfo(socket);
                    break;
                }
                default: {
                    System.err.println("Unknown agent : " + agent);
                    socket.close("Unknown agent : " + agent);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLobbyInfo(Connection socket) throws IOException {
        List<RoomInformation> list = this.rooms;
        synchronized (list) {
            if (System.currentTimeMillis() > this.roomsLastUpdatedTime + 5000L) {
                this.rooms.clear();
                Map<String, GameServer> map = this.servers;
                synchronized (map) {
                    this.rooms.addAll(this.servers.entrySet().stream().filter(e -> ((GameServer)e.getValue()).getConfig().isPublic()).map(e -> {
                        RoomInformation info = new RoomInformation((String)e.getKey(), ((GameServer)e.getValue()).getConfig());
                        info.setPlayerNum(((GameServer)e.getValue()).getPlayerNum());
                        return info;
                    }).collect(Collectors.toList()));
                }
                this.roomsLastUpdatedTime = System.currentTimeMillis();
            }
            for (RoomInformation r : this.rooms) {
                socket.oos.writeUTF(r.getId());
                r.write(socket.oos);
            }
        }
        socket.close("end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGuest(Connection socket) throws IOException {
        String room = socket.ois.readUTF();
        GameServer s = null;
        if (room.equals("auto")) {
            Map<String, GameServer> map = this.servers;
            synchronized (map) {
                s = this.servers.values().stream().filter(gs -> gs.getConfig().isPublic() && !gs.isFull()).findAny().orElse(null);
            }
        }
        Map<String, GameServer> map = this.servers;
        synchronized (map) {
            if (this.servers.containsKey(room)) {
                s = this.servers.get(room);
            }
        }
        if (s != null) {
            socket.oos.writeUTF("OK");
            socket.oos.flush();
            s.acceptPlayer(socket);
        } else {
            socket.close("Room not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHost(Connection socket) throws IOException {
        socket.oos.writeUTF("OK");
        socket.oos.flush();
        RoomConfig config = new RoomConfig();
        config.read(socket.ois);
        GameServer s = new GameServer(socket, config);
        String room = LobbyServer.getRandomString();
        Map<String, GameServer> map = this.servers;
        synchronized (map) {
            while (this.servers.containsKey(room)) {
                room = LobbyServer.getRandomString();
            }
            this.servers.put(room, s);
        }
        try {
            socket.oos.writeUTF(room);
            socket.oos.flush();
        }
        catch (IOException e) {
            Map<String, GameServer> map2 = this.servers;
            synchronized (map2) {
                this.servers.remove(room);
            }
            return;
        }
        String roomID = room;
        s.setCloneFunc(() -> {
            Map<String, GameServer> map = this.servers;
            synchronized (map) {
                this.servers.remove(roomID);
            }
        });
        s.run();
    }

    private static String getRandomString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 6) {
            sb.append((char)(Math.random() * 26.0 + 65.0));
            ++i;
        }
        return sb.toString();
    }
}

