/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.MachineChecker;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.craftalos.program.compiler.ProgramCompiler;
import net.comp_lot.craftalos.system.World;
import net.comp_lot.craftalos.system.network.Connection;
import net.comp_lot.craftalos.system.network.SocketConnection;
import net.comp_lot.craftalos.system.network.SyncWrapper;
import net.comp_lot.craftalos.system.network.data.ControlData;
import net.comp_lot.craftalos.system.network.data.ControlDataCache;
import net.comp_lot.craftalos.system.network.data.ControlDataMaster;
import net.comp_lot.craftalos.system.network.data.WorldData;
import net.comp_lot.craftalos.system.network.data.WorldDataCache;
import net.comp_lot.craftalos.system.network.data.WorldDataMaster;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.system.utils.FPSKeeper;

public class GameServerClient {
    private final RoomConfig config;
    private volatile boolean running = true;
    private Connection socket;
    private int cnt;
    private final SyncWrapper<WorldDataMaster> worldData;
    private final SyncWrapper<WorldDataCache> worldDataCache = new SyncWrapper<WorldDataCache>(new WorldDataCache());
    private final SyncWrapper<ControlDataMaster> controlData;
    private final SyncWrapper<ControlDataCache> controlDataCache = new SyncWrapper<ControlDataCache>(new ControlDataCache());
    private final Queue<Message> messageQueue = new ConcurrentLinkedQueue<Message>();
    private volatile boolean modelChanged = false;
    private final Queue<String> joinQueue = new LinkedList<String>();
    private final Queue<Integer> leaveQueue = new LinkedList<Integer>();

    public GameServerClient(RoomConfig config, String address, int port, boolean ssl) {
        this(config);
        try {
            this.init(SocketConnection.open(address, port, ssl));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public GameServerClient(RoomConfig config, Connection socket) {
        this(config);
        try {
            this.init(socket);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private GameServerClient(RoomConfig config) {
        this.config = config;
        World world = new World(s -> {
            boolean bl = this.messageQueue.add(new Message(-1, (String)s));
        }, config.getMapRealName(), config.isDamageEnable());
        ArrayList<Machine> machineList = new ArrayList<Machine>();
        this.worldData = new SyncWrapper<WorldDataMaster>(new WorldDataMaster(world, machineList));
        this.controlData = new SyncWrapper<ControlDataMaster>(new ControlDataMaster(machineList));
    }

    private void init(Connection socket) throws IOException {
        this.socket = socket;
        socket.oos.writeUTF("host \u03b21.5.0");
        socket.oos.flush();
        String state = socket.ois.readUTF();
        if (!state.equals("OK")) {
            System.err.println(state);
            return;
        }
        this.config.write(socket.oos);
        socket.oos.flush();
        Main.room = socket.ois.readUTF();
        new Thread(this::gameLoop, "CT Room Compute").start();
        new Thread(this::sendLoop, "CT Room Send").start();
        new Thread(this::receiveLoop, "CT Room Receive").start();
        System.out.println("Host start : room=" + Main.room);
    }

    public void close() {
        this.running = false;
    }

    private void gameLoop() {
        FPSKeeper fpsKeeper = new FPSKeeper(60);
        fpsKeeper.loop(() -> {
            this.frame(fpsKeeper.getFps());
            return this.running;
        });
    }

    private void sendLoop() {
        while (this.running) {
            try {
                this.worldDataCache.accept(wdc -> {
                    if (wdc.getCnt() == this.cnt) {
                        wdc.wait();
                    }
                    this.cnt = wdc.getCnt();
                    this.send((WorldDataCache)wdc);
                });
            }
            catch (Exception e) {
                this.close();
            }
        }
        this.socket.close();
    }

    private void receiveLoop() {
        while (this.running) {
            try {
                this.receive();
            }
            catch (IOException e) {
                this.close();
            }
        }
        this.socket.close();
    }

    private void frame(double fps) {
        this.controlDataCache.accept(cdc -> {
            if (cdc.isUpdated()) {
                this.controlData.accept(cd -> cd.copy((ControlData)cdc));
                cdc.resetUpdated();
            }
        });
        this.controlData.accept(cd -> this.worldData.accept(wd -> {
            wd.frame(fps);
            this.modelChanged = wd.getAndResetModelChanged();
        }));
        this.worldDataCache.accept(wdc -> this.worldData.accept(wd -> {
            wdc.copy((WorldData)wd);
            wdc.notify();
        }));
    }

    private void send(WorldDataCache ds) throws IOException {
        this.sendModel();
        this.socket.oos.writeUTF("wrd");
        ds.write(this.socket.oos);
        this.sendMessage();
        this.sendJoin();
        this.sendLeave();
        this.socket.oos.writeUTF("end");
        this.socket.oos.flush();
        this.socket.oos.reset();
    }

    private void receive() throws IOException {
        block12: while (true) {
            switch (this.socket.ois.readUTF()) {
                case "ctrl": {
                    this.controlDataCache.accept(cdc -> {
                        cdc.read(this.socket.ois);
                        cdc.setUpdated();
                    });
                    continue block12;
                }
                case "join": {
                    this.readMachine();
                    continue block12;
                }
                case "rem": {
                    this.removePlayer();
                    continue block12;
                }
                default: {
                    throw new IOException("Unknown data type.");
                }
                case "end": 
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJoin() throws IOException {
        Queue<String> queue = this.joinQueue;
        synchronized (queue) {
            while (!this.joinQueue.isEmpty()) {
                this.joinMachine(this.joinQueue.poll(), this.joinQueue.poll());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLeave() throws IOException {
        Queue<Integer> queue = this.leaveQueue;
        synchronized (queue) {
            while (!this.leaveQueue.isEmpty()) {
                this.socket.oos.writeUTF("rem");
                this.socket.oos.writeInt(this.leaveQueue.poll());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlayer() throws IOException {
        int num = this.socket.ois.readInt();
        this.controlDataCache.accept(cdc -> this.worldDataCache.accept(wdc -> this.controlData.accept(cd -> this.worldData.accept(wd -> {
            wd.removePlayer(num);
            wd.getCSList().clear();
            wdc.removePlayer(num);
            cdc.removePlayer(num);
        }))));
        Queue<Integer> queue = this.leaveQueue;
        synchronized (queue) {
            this.leaveQueue.add(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMachine() throws IOException {
        String bcm = this.socket.ois.readUTF();
        String bcp = this.socket.ois.readUTF();
        Queue<String> queue = this.joinQueue;
        synchronized (queue) {
            this.joinQueue.add(bcm);
            this.joinQueue.add(bcp);
        }
    }

    private void joinMachine(String bcm, String bcp) throws IOException {
        Machine machine;
        this.socket.oos.writeUTF("join");
        try {
            machine = MachineCompiler.compile(bcm);
            machine.getModel().callConfirmCoordinate();
            machine.getModel().setBound();
            machine.getRootPart().getModel().moveP(machine.getModel().getBound().getCenter(), -1.0);
            machine.getRootPart().getModel().moveP(Vector.Y_AXIS, machine.getModel().getBound().getHeight() * 0.5);
            this.worldData.accept(wd -> {
                int id = wd.getNextId();
                machine.setPrinter(s -> {
                    boolean bl = this.messageQueue.add(new Message(id, (String)s));
                });
            });
        }
        catch (CompileException e) {
            this.sendJoinState(e.getDetailMessage(bcm), -1);
            return;
        }
        try {
            machine.setProgram(ProgramCompiler.compile(bcp));
        }
        catch (CompileException e) {
            this.sendJoinState(e.getDetailMessage(bcp), -1);
            return;
        }
        if (!this.checkMachine(machine)) {
            return;
        }
        this.sendJoinState("Join : OK", machine.getModel().id);
        MutVector camera = new MutVector();
        this.controlDataCache.accept(cdc -> this.worldDataCache.accept(wdc -> this.controlData.accept(cd -> this.worldData.accept(wd -> {
            wd.addPlayer(machine);
            wdc.addPlayer();
            cdc.addPlayer();
            machine.getModel().LocalToGlobal(camera, Vector.Z_AXIS);
        }))));
        camera.write(this.socket.oos);
        this.socket.oos.flush();
    }

    private void sendJoinState(String state, int modelId) throws IOException {
        this.socket.oos.writeUTF(state);
        this.socket.oos.writeInt(modelId);
        this.socket.oos.flush();
    }

    private boolean checkMachine(Machine machine) throws IOException {
        MachineChecker mc = new MachineChecker(machine);
        if (!mc.check()) {
            this.sendJoinState(mc.getMessage(), -1);
            return false;
        }
        if ((this.config.isPublic() || Main.missionID != null) && machine.countWeight() > 750) {
            this.sendJoinState(StringManager.lang.serverMachineTooHeavy(750), -1);
            return false;
        }
        return true;
    }

    private void sendModel() throws IOException {
        if (this.modelChanged) {
            this.socket.oos.writeUTF("mdl");
            this.worldData.accept(wd -> {
                this.modelChanged = false;
                this.socket.oos.writeObject(wd.getModel());
            });
        }
    }

    private void sendMessage() throws IOException {
        while (!this.messageQueue.isEmpty()) {
            Message m = this.messageQueue.poll();
            this.socket.oos.writeUTF("msg");
            this.socket.oos.writeInt(m.id);
            this.socket.oos.writeUTF(m.message);
        }
    }

    private static class Message {
        final int id;
        final String message;

        Message(int id, String message) {
            this.id = id;
            this.message = message;
        }
    }
}

