/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.system.network.Connection;
import net.comp_lot.craftalos.system.network.SyncWrapper;
import net.comp_lot.craftalos.system.network.data.ControlData;
import net.comp_lot.craftalos.system.network.data.ControlDataCache;
import net.comp_lot.craftalos.system.network.data.WorldDataCache;
import net.comp_lot.craftalos.system.network.server.AbstractServer;
import net.comp_lot.craftalos.system.network.server.PlayerConnection;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.system.utils.FPSKeeper;

public class GameServer
implements AbstractServer,
Runnable {
    private volatile boolean running = true;
    private Runnable closeFunc = () -> {};
    private final Connection socket;
    private final PlayerUpdate playerUpdate = new PlayerUpdate();
    private final List<PlayerConnection> players = new ArrayList<PlayerConnection>();
    private final Queue<PlayerConnection> joinQueue = new LinkedList<PlayerConnection>();
    private volatile int playerNum = 0;
    private final Consumer<String> printer = s -> this.players.parallelStream().filter(p -> p != null).forEach(p -> p.print((String)s));
    private boolean modelChanged = false;
    private Model model = null;
    private final RoomConfig config;
    private final WorldDataCache worldData = new WorldDataCache();
    private final SyncWrapper<WorldDataCache> worldDataCache = new SyncWrapper<WorldDataCache>(new WorldDataCache());
    private final ControlDataCache controlData = new ControlDataCache();
    private final SyncWrapper<ControlDataCache> controlDataCache = new SyncWrapper<ControlDataCache>(new ControlDataCache());

    public GameServer(Connection socket, RoomConfig config) {
        this.socket = socket;
        this.config = config;
    }

    public void stop() {
        this.running = false;
    }

    public void setCloneFunc(Runnable func) {
        this.closeFunc = func;
    }

    @Override
    public void run() {
        new Thread(this::sendLoop, "CT Server Send").start();
        new Thread(this::receiveLoop, "CT Server Receive").start();
    }

    private void sendLoop() {
        new FPSKeeper(120).loop(() -> {
            this.controlDataCache.accept(cdc -> {
                if (cdc.isUpdated()) {
                    this.controlData.copy((ControlData)cdc);
                    cdc.resetUpdated();
                }
            });
            try {
                this.send(this.controlData);
            }
            catch (IOException e) {
                this.running = false;
            }
            return this.running;
        });
        this.close();
    }

    private void receiveLoop() {
        while (this.running) {
            try {
                this.receive(this.worldData);
            }
            catch (IOException e) {
                this.running = false;
            }
            this.worldDataCache.accept(wdc -> {
                wdc.copy(this.worldData);
                wdc.notifyAll();
            });
            if (!this.modelChanged) continue;
            this.players.parallelStream().filter(p -> p != null).forEach(p -> p.updateModelHost());
            this.modelChanged = false;
        }
    }

    private void close() {
        this.running = false;
        this.players.parallelStream().filter(p -> p != null).forEach(p -> p.stop());
        this.socket.close();
        this.closeFunc.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptPlayer(Connection socket) {
        block7: {
            try {
                PlayerConnection p = new PlayerConnection(socket, this);
                if (this.isFull()) {
                    p.sendJoinState("Room is full", 0);
                    p.stop();
                    break block7;
                }
                PlayerUpdate playerUpdate = this.playerUpdate;
                synchronized (playerUpdate) {
                    this.playerUpdate.updated = true;
                    this.playerUpdate.newPlayer.add(p);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CompileException e) {
                System.out.println("Not joined : compile error");
            }
        }
    }

    public boolean isFull() {
        return this.playerNum >= this.config.getPlayerNum();
    }

    public RoomConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(ControlDataCache cd) throws IOException {
        this.socket.oos.writeUTF("ctrl");
        cd.write(this.socket.oos);
        if (this.playerUpdate.updated) {
            PlayerUpdate playerUpdate = this.playerUpdate;
            synchronized (playerUpdate) {
                this.updatePlayer();
            }
        }
        this.socket.oos.writeUTF("end");
        this.socket.oos.flush();
        this.socket.oos.reset();
    }

    private void receive(WorldDataCache wdc) throws IOException {
        block16: while (true) {
            switch (this.socket.ois.readUTF()) {
                case "mdl": {
                    this.readModel();
                    continue block16;
                }
                case "wrd": {
                    wdc.read(this.socket.ois);
                    continue block16;
                }
                case "msg": {
                    int id = this.socket.ois.readInt();
                    String message = this.socket.ois.readUTF();
                    if (id < 0) {
                        this.printer.accept(message);
                        continue block16;
                    }
                    if (this.players.get(id) == null) continue block16;
                    this.players.get(id).print(message);
                    continue block16;
                }
                case "join": {
                    this.readPlayer();
                    continue block16;
                }
                case "rem": {
                    this.readPlayerRemove();
                    continue block16;
                }
                default: {
                    throw new RuntimeException("Unknown data type.");
                }
                case "end": 
            }
            break;
        }
        wdc.increment();
    }

    private void readModel() throws IOException {
        try {
            this.model = (Model)this.socket.ois.readObject();
            this.modelChanged = true;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private void readPlayer() throws IOException {
        PlayerConnection pc = this.joinQueue.poll();
        String state = this.socket.ois.readUTF();
        int id = this.socket.ois.readInt();
        pc.sendJoinState(state, id);
        if (state.endsWith("OK")) {
            pc.setId(this.players.size(), id);
            MutVector camera = new MutVector();
            camera.read(this.socket.ois);
            pc.sendInitialCamera(camera);
            this.players.add(pc);
            this.worldData.addPlayer();
            this.worldDataCache.accept(wdc -> wdc.addPlayer());
            this.controlData.addPlayer();
            this.controlDataCache.accept(cdc -> cdc.addPlayer());
            pc.start();
        } else {
            pc.stop();
        }
        this.playerNum = (int)this.players.parallelStream().filter(p -> p != null).count();
    }

    private void readPlayerRemove() throws IOException {
        int num = this.socket.ois.readInt();
        this.players.set(num, null);
        this.worldData.removePlayer(num);
        this.worldDataCache.accept(wdc -> wdc.removePlayer(num));
        this.playerNum = (int)this.players.parallelStream().filter(p -> p != null).count();
    }

    private void updatePlayer() throws IOException {
        int i = 0;
        while (i < this.players.size()) {
            if (this.players.get(i) != null && !this.players.get(i).isRunning()) {
                this.removePlayer(i);
            }
            ++i;
        }
        for (PlayerConnection p2 : this.playerUpdate.newPlayer) {
            this.joinPlayer(p2);
        }
        this.playerNum = (int)this.players.parallelStream().filter(p -> p != null).count();
        this.playerUpdate.newPlayer.clear();
        this.playerUpdate.updated = false;
    }

    private void removePlayer(int num) throws IOException {
        this.socket.oos.writeUTF("rem");
        this.socket.oos.writeInt(num);
        this.controlData.removePlayer(num);
        this.controlDataCache.accept(cdc -> cdc.removePlayer(num));
    }

    private void joinPlayer(PlayerConnection p) throws IOException {
        this.socket.oos.writeUTF("join");
        this.socket.oos.writeUTF(p.getBcm());
        this.socket.oos.writeUTF(p.getBcp());
        this.socket.oos.flush();
        this.joinQueue.add(p);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlayer() {
        PlayerUpdate playerUpdate = this.playerUpdate;
        synchronized (playerUpdate) {
            this.playerUpdate.updated = true;
        }
    }

    @Override
    public SyncWrapper<WorldDataCache> getWorldData() {
        return this.worldDataCache;
    }

    @Override
    public SyncWrapper<ControlDataCache> getControlData() {
        return this.controlDataCache;
    }

    public int getPlayerNum() {
        return this.playerNum;
    }

    private static class PlayerUpdate {
        private volatile boolean updated = false;
        private final List<PlayerConnection> newPlayer = new ArrayList<PlayerConnection>();

        private PlayerUpdate() {
        }
    }
}

