/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network.data;

import java.util.List;
import java.util.stream.Collectors;
import net.comp_lot.craftalos.game.GameCamera;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.MachineState;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.system.World;
import net.comp_lot.craftalos.system.network.data.WorldData;
import net.comp_lot.glui.model.CoordinateSystem;
import net.comp_lot.glui.model.Model;

public class WorldDataMaster
implements WorldData {
    private int cnt = 0;
    private final World world;
    private final List<Machine> machineList;
    private float fps;

    public WorldDataMaster(World world, List<Machine> machineList) {
        this.world = world;
        this.machineList = machineList;
    }

    public void frame(double fps) {
        this.world.frame();
        ++this.cnt;
        this.fps = (float)fps * 5.0f;
    }

    public Model getModel() {
        return this.world.getModel();
    }

    public boolean getAndResetModelChanged() {
        boolean rtn = this.world.isModelChanged();
        this.world.resetModelChanged();
        return rtn;
    }

    public int getNextId() {
        return this.machineList.size();
    }

    public void addPlayer(Machine machine) {
        this.world.addPlayerMachine(machine);
        this.world.initCoordinateAndBound();
        this.world.runMapProgram();
        this.world.getModel().callConfirmCoordinate();
        this.world.getCSList().forEach(cs -> cs.setChangedToFalse());
        this.machineList.add(machine);
    }

    public void removePlayer(int id) {
        Machine machine = this.machineList.get(id);
        machine.resetEndurance();
        this.world.removePlayerMachine(machine);
        this.machineList.set(id, null);
    }

    @Override
    public int getCnt() {
        return this.cnt;
    }

    @Override
    public List<CoordinateSystem> getCSList() {
        return this.world.getCSList();
    }

    @Override
    public List<Entity> getEntities() {
        return this.world.getEntityList();
    }

    @Override
    public List<GameCamera> getCameras() {
        return this.machineList.stream().map(m -> m != null ? m.getCamera() : null).collect(Collectors.toList());
    }

    @Override
    public List<MachineState> getMachineStates() {
        return this.machineList.stream().map(m -> m != null ? m.getState() : null).collect(Collectors.toList());
    }

    @Override
    public float getServerFps() {
        return this.fps;
    }
}

