/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.comp_lot.craftalos.game.GameCamera;
import net.comp_lot.craftalos.game.MachineState;
import net.comp_lot.craftalos.game.entity.BulletPredict;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.system.network.data.WorldData;
import net.comp_lot.glui.amount.FastSerializable;
import net.comp_lot.glui.model.CoordinateSystem;

public class WorldDataCache
implements WorldData,
FastSerializable {
    private final int id;
    private final int machineId;
    private int cnt = 0;
    private final List<CoordinateSystem> csList = new ArrayList<CoordinateSystem>();
    private final List<GameCamera> cameras = new ArrayList<GameCamera>();
    private final List<MachineState> machineStates = new ArrayList<MachineState>();
    private final List<Entity> entities = new ArrayList<Entity>();
    private float fps;
    private final Map<Entity, Entity> entitiesBuf = new HashMap<Entity, Entity>();

    public WorldDataCache() {
        this.id = -1;
        this.machineId = -1;
    }

    public WorldDataCache(int id, int machineId) {
        this.id = id;
        this.machineId = machineId;
        this.addPlayer();
    }

    public void addPlayer() {
        this.cameras.add(new GameCamera());
        this.machineStates.add(new MachineState());
    }

    public void removePlayer(int id) {
        this.cameras.set(id, null);
        this.machineStates.set(id, null);
        this.getCSList().clear();
    }

    public void copy(WorldData upstream) {
        if (this.getCnt() == upstream.getCnt()) {
            return;
        }
        this.cnt = upstream.getCnt();
        if (this.id == -1) {
            int i = 0;
            while (i < upstream.getCameras().size()) {
                if (upstream.getCameras().get(i) != null) {
                    this.getCameras().get(i).set(upstream.getCameras().get(i));
                    this.getMachineStates().get(i).copy(upstream.getMachineStates().get(i));
                }
                ++i;
            }
        } else {
            this.getCameras().get(0).set(upstream.getCameras().get(this.id));
            this.getMachineStates().get(0).copy(upstream.getMachineStates().get(this.id));
        }
        this.updateCSList(upstream.getCSList(), this.id == -1);
        this.updateEntities(upstream.getEntities());
        this.fps = upstream.getServerFps();
    }

    @Override
    public List<CoordinateSystem> getCSList() {
        return this.csList;
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<GameCamera> getCameras() {
        return this.cameras;
    }

    @Override
    public List<MachineState> getMachineStates() {
        return this.machineStates;
    }

    @Override
    public float getServerFps() {
        return this.fps;
    }

    private void updateEntities(List<Entity> entities) {
        this.entitiesBuf.clear();
        this.getEntities().stream().forEach(b -> {
            Entity entity = this.entitiesBuf.put((Entity)b, (Entity)b);
        });
        this.getEntities().clear();
        entities.stream().filter(e -> this.id < 0 || !(e instanceof BulletPredict) || ((BulletPredict)e).getParentId() == this.machineId).forEach(b -> {
            if (this.entitiesBuf.containsKey(b)) {
                Entity e = this.entitiesBuf.remove(b);
                e.copy((Entity)b);
                this.getEntities().add(e);
            } else {
                this.getEntities().add(b.clone());
            }
        });
    }

    private void updateCSList(List<CoordinateSystem> csList, boolean resetChanged) {
        csList.stream().filter(cs -> cs.isChanged()).forEach(cs -> {
            CoordinateSystem dst;
            int i = Collections.binarySearch(this.getCSList(), cs, (a, b) -> Integer.compare(a.getId(), b.getId()));
            if (i < 0) {
                i = -i - 1;
                this.getCSList().add(i, new CoordinateSystem(-1));
            }
            if (this.csChanged((CoordinateSystem)cs, dst = this.getCSList().get(i))) {
                dst.cloneCopy((CoordinateSystem)cs);
            }
            if (resetChanged) {
                cs.setChangedToFalse();
            }
        });
    }

    private boolean csChanged(CoordinateSystem src, CoordinateSystem dst) {
        if (this.id < 0) {
            return !dst.equalsAt(src, 16.0, 256.0);
        }
        return !dst.equalsAt(src, 16.0, 256.0);
    }

    @Override
    public int getCnt() {
        return this.cnt;
    }

    public void increment() {
        ++this.cnt;
    }

    @Override
    public void write(ObjectOutputStream os) throws IOException {
        this.writeCSList(os);
        this.writeCamera(os);
        this.writeMachineState(os);
        this.writeEntities(os);
        this.writeServerFps(os);
    }

    private void writeServerFps(ObjectOutputStream os) throws IOException {
        os.writeFloat(this.fps);
    }

    private void writeCSList(ObjectOutputStream os) throws IOException {
        for (CoordinateSystem cs : this.getCSList()) {
            if (!cs.isChanged()) continue;
            os.writeInt(cs.getId());
            cs.write(os);
            cs.setChangedToFalse();
        }
        os.writeInt(-1);
    }

    private void writeCamera(ObjectOutputStream os) throws IOException {
        int i = 0;
        while (i < this.getCameras().size()) {
            if (this.getCameras().get(i) != null) {
                os.writeInt(i);
                this.getCameras().get(i).write(os);
            }
            ++i;
        }
        os.writeInt(-1);
    }

    private void writeMachineState(ObjectOutputStream os) throws IOException {
        int i = 0;
        while (i < this.getMachineStates().size()) {
            if (this.getMachineStates().get(i) != null) {
                os.writeInt(i);
                this.getMachineStates().get(i).write(os);
            }
            ++i;
        }
        os.writeInt(-1);
    }

    private void writeEntities(ObjectOutputStream os) throws IOException {
        os.writeInt(this.getEntities().size());
        for (Entity e : this.getEntities()) {
            e.writeEntity(os);
        }
    }

    @Override
    public void read(ObjectInputStream is) throws IOException {
        this.readCSList(is);
        this.readCamera(is);
        this.readMachineState(is);
        this.readEntities(is);
        this.readServerFps(is);
    }

    private void readServerFps(ObjectInputStream is) throws IOException {
        this.fps = is.readFloat();
    }

    private void readCSList(ObjectInputStream is) throws IOException {
        CoordinateSystem buf = new CoordinateSystem(-1);
        int id = is.readInt();
        while (id >= 0) {
            buf.setId(id);
            int i = Collections.binarySearch(this.getCSList(), buf, (a, b) -> Integer.compare(a.getId(), b.getId()));
            if (i < 0) {
                i = -i - 1;
                this.getCSList().add(i, new CoordinateSystem(id));
            }
            this.getCSList().get(i).read(is);
            id = is.readInt();
        }
    }

    private void readCamera(ObjectInputStream is) throws IOException {
        int num = is.readInt();
        while (num >= 0) {
            this.getCameras().get(num).read(is);
            num = is.readInt();
        }
    }

    private void readMachineState(ObjectInputStream is) throws IOException {
        int num = is.readInt();
        while (num >= 0) {
            this.getMachineStates().get(num).read(is);
            num = is.readInt();
        }
    }

    private void readEntities(ObjectInputStream is) throws IOException {
        this.getEntities().clear();
        int num = is.readInt();
        int i = 0;
        while (i < num) {
            this.getEntities().add(Entity.readEntity(is));
            ++i;
        }
    }
}

