/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.glui.amount.FastSerializable;

public class RoomInformation
implements FastSerializable {
    private String id;
    private RoomConfig config;
    private int playerNum;

    public RoomInformation() {
        this.config = new RoomConfig();
    }

    public RoomInformation(String id, RoomConfig config) {
        this.id = id;
        this.config = config;
    }

    public String getId() {
        return this.id;
    }

    public RoomConfig getConfig() {
        return this.config;
    }

    public void setPlayerNum(int playerNum) {
        this.playerNum = playerNum;
    }

    public int getPlayerNum() {
        return this.playerNum;
    }

    public boolean isFull() {
        return this.getPlayerNum() >= this.config.getPlayerNum();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        sb.append(" | ");
        sb.append(this.config.getMode());
        sb.append(" | ");
        sb.append(this.getPlayerNum());
        sb.append("/");
        sb.append(this.config.getPlayerNum());
        sb.append(" | ");
        sb.append(this.config.getMapAlias());
        sb.append(" | ");
        sb.append(this.config.isDamageEnable());
        sb.append(" | ");
        sb.append(this.config.getAircraft());
        return sb.toString();
    }

    @Override
    public void read(ObjectInputStream s) throws IOException {
        this.id = s.readUTF();
        this.config.read(s);
        this.playerNum = s.readInt();
    }

    @Override
    public void write(ObjectOutputStream s) throws IOException {
        s.writeUTF(this.id);
        this.config.write(s);
        s.writeInt(this.playerNum);
    }
}

