/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.system.network.data.ControlData;
import net.comp_lot.glui.amount.FastSerializable;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.UpdateFlagData;
import net.comp_lot.glui.system.OperationEvent;

public class ControlDataCache
extends UpdateFlagData
implements ControlData,
FastSerializable {
    private final int id;
    private final List<OperationEvent.KeyState> keyState = new ArrayList<OperationEvent.KeyState>();
    private final List<MutVector> camerasAxis = new ArrayList<MutVector>();

    public ControlDataCache() {
        this.id = -1;
    }

    public ControlDataCache(int id) {
        this.id = id;
        this.addPlayer();
    }

    public void addPlayer() {
        this.keyState.add(new OperationEvent.KeyState());
        this.camerasAxis.add(new MutVector());
    }

    public void removePlayer(int id) {
        this.keyState.set(id, null);
        this.camerasAxis.set(id, null);
    }

    @Override
    public List<OperationEvent.KeyState> getKeyState() {
        return this.keyState;
    }

    @Override
    public List<MutVector> getCamerasAxis() {
        return this.camerasAxis;
    }

    public void copy(ControlData upstream) {
        if (this.getId() == upstream.getId()) {
            if (this.getId() < 0) {
                int i = 0;
                while (i < upstream.getCamerasAxis().size()) {
                    if (upstream.getCamerasAxis().get(i) != null) {
                        this.getKeyState().get(i).set(upstream.getKeyState().get(i));
                        this.getCamerasAxis().get(i).set(upstream.getCamerasAxis().get(i));
                    }
                    ++i;
                }
            } else {
                this.getKeyState().get(0).set(upstream.getKeyState().get(0));
                this.getCamerasAxis().get(0).set(upstream.getCamerasAxis().get(0));
            }
        } else {
            this.getKeyState().get(upstream.getId()).set(upstream.getKeyState().get(0));
            this.getCamerasAxis().get(upstream.getId()).set(upstream.getCamerasAxis().get(0));
        }
        this.setUpdated();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void write(ObjectOutputStream os) throws IOException {
        this.writeKeyState(os);
        this.writeCameraAxis(os);
    }

    private void writeKeyState(ObjectOutputStream os) throws IOException {
        int i = 0;
        while (i < this.getKeyState().size()) {
            if (this.getKeyState().get(i) != null) {
                os.writeInt(i);
                this.getKeyState().get(i).write(os);
            }
            ++i;
        }
        os.writeInt(-1);
    }

    private void writeCameraAxis(ObjectOutputStream os) throws IOException {
        int i = 0;
        while (i < this.getCamerasAxis().size()) {
            if (this.getCamerasAxis().get(i) != null) {
                os.writeInt(i);
                this.getCamerasAxis().get(i).write(os);
            }
            ++i;
        }
        os.writeInt(-1);
    }

    @Override
    public void read(ObjectInputStream is) throws IOException {
        this.readKey(is);
        this.readCameraAxis(is);
    }

    private void readKey(ObjectInputStream is) throws IOException {
        int id = is.readInt();
        while (id >= 0) {
            this.getKeyState().get(id).read(is);
            id = is.readInt();
        }
    }

    private void readCameraAxis(ObjectInputStream is) throws IOException {
        int id = is.readInt();
        while (id >= 0) {
            this.getCamerasAxis().get(id).read(is);
            id = is.readInt();
        }
    }
}

