/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.network;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLSocketFactory;
import net.comp_lot.craftalos.system.network.Connection;

public class SocketConnection
extends Connection {
    private final Socket socket;

    private SocketConnection(Socket socket, ObjectOutputStream oos, ObjectInputStream ois) {
        super(oos, ois);
        this.socket = socket;
    }

    public static SocketConnection open(Socket socket, boolean server) throws IOException {
        ObjectOutputStream oos;
        ObjectInputStream ois;
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (server) {
            ois = new ObjectInputStream(new InflaterInputStream(new BufferedInputStream(socket.getInputStream())));
            oos = new ObjectOutputStream(new BufferedOutputStream(new DeflaterOutputStream(socket.getOutputStream(), true)));
            oos.flush();
        } else {
            oos = new ObjectOutputStream(new BufferedOutputStream(new DeflaterOutputStream(socket.getOutputStream(), true)));
            oos.flush();
            ois = new ObjectInputStream(new InflaterInputStream(new BufferedInputStream(socket.getInputStream())));
        }
        return new SocketConnection(socket, oos, ois);
    }

    public static SocketConnection open(String address, int port, boolean ssl) throws IOException {
        return SocketConnection.open(SocketConnection.getSocket(address, port, ssl), false);
    }

    private static Socket getSocket(String address, int port, boolean ssl) throws IOException {
        Socket socket = ssl ? SSLSocketFactory.getDefault().createSocket() : new Socket();
        socket.connect(new InetSocketAddress(address, port), 1500);
        return socket;
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getInetAddress() {
        return this.socket.getInetAddress().toString();
    }
}

