/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import net.comp_lot.craftalos.game.Part;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.CoordinateSystem;

class RotationManager {
    private final MutVector center = new MutVector();
    private final MutVector axis = new MutVector();
    private double angle;
    private int time;

    RotationManager() {
    }

    public void setRotation(Vector center, Vector axis, double angle, int frameLength) {
        this.center.set(center);
        this.axis.set(axis);
        this.angle = angle;
        this.time = frameLength;
    }

    public void animatePart(Part part) {
        part.getModel().rotateShapes(this.center, this.axis, this.angle / (double)this.time);
        this.reduce();
    }

    public void animateCoordinateSystem(CoordinateSystem cs, CoordinateSystem mirror) {
        cs.rotate(this.center, this.axis, this.angle / (double)this.time);
        if (this.axis.getX() != 0.0) {
            mirror.rotate(this.axis, this.angle / (double)this.time);
        } else {
            mirror.rotate(this.axis, -this.angle / (double)this.time);
        }
        this.reduce();
    }

    private void reduce() {
        this.angle -= this.angle / (double)this.time--;
    }

    public boolean isRotating() {
        return this.time > 0;
    }

    public void setSkip() {
        this.time = 1;
    }
}

