/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import java.util.function.Consumer;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.GamePlayMode;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.glui.ui.TextInput;

class RenameMenu {
    private final GamePlayMode context;

    public RenameMenu(GamePlayMode context) {
        this.context = context;
    }

    public void show(String currentName, Consumer<String> function) {
        MenuManager menu = new MenuManager(this.context.getUIDisplay());
        menu.setGetter("$name", args -> currentName);
        menu.setListener("$name", args -> {
            TextInput textInput = this.setTextInput(function, menu);
        });
        menu.setListener("ok", args -> {
            function.accept(menu.getForm("$name").getText());
            this.context.showMenu(null);
        });
        menu.setListener("cancel", args -> this.context.showMenu(null));
        menu.set(StringManager.lang.gameMenuPath() + "rename.md");
        this.context.showMenu(menu.getComponent());
        this.setTextInput(function, menu).setCursor(Integer.MAX_VALUE);
    }

    private TextInput setTextInput(Consumer<String> function, MenuManager menu) {
        TextInput textInput = new TextInput(menu.getForm("$name"));
        textInput.setConfirmFunc(() -> {
            function.accept(menu.getForm("$name").getText());
            this.context.showMenu(null);
        });
        this.context.setActiveComponent(textInput);
        return textInput;
    }
}

