/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.MachineChecker;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.ConnectionBlock;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.craftalos.system.edit.EditMode;
import net.comp_lot.craftalos.system.edit.MachineManager;
import net.comp_lot.glui.display_lwjgl.GLDataUtil;
import net.comp_lot.glui.system.utils.FileUtils;

class MachineWriter {
    private final EditMode mode;

    MachineWriter(EditMode mode) {
        this.mode = mode;
    }

    boolean saveModel(Machine machine, List<MachineManager.Pair<ConnectionBlock, Part>> partsList, String fileName) {
        FileUtils.writeFile(fileName + ".bcm", this.makeString(machine, partsList));
        try {
            Machine m = MachineCompiler.compile(FileUtils.loadFile(fileName + ".bcm"));
            MachineChecker checker = new MachineChecker(m);
            if (!checker.check()) {
                System.out.println("Warning: " + checker.getMessage());
            }
            System.out.println("model saved.");
            return true;
        }
        catch (FileNotFoundException | CompileException e) {
            System.out.println("save failed.");
            return false;
        }
    }

    String makeString(Machine machine, List<MachineManager.Pair<ConnectionBlock, Part>> partsList) {
        machine.getModel().callConfirmCoordinate();
        machine.getMachinePart().computeCenter();
        return this.printPart((Part)partsList.get((int)0).value, 0, new StringBuilder(), partsList).toString();
    }

    private StringBuilder printPart(Part part, int space, StringBuilder sb, List<MachineManager.Pair<ConnectionBlock, Part>> partsList) {
        sb.append("{\n");
        part.getAllBlocks().forEach(block -> {
            MachineWriter.printBlock(block, space + 1, sb);
            if (block instanceof ConnectionBlock) {
                for (MachineManager.Pair p : partsList) {
                    if (p.key != block) continue;
                    this.printPart((Part)p.value, space + 1, sb, partsList);
                    break;
                }
            }
            sb.append("\n");
        });
        int i = 0;
        while (i < space) {
            sb.append("\t");
            ++i;
        }
        sb.append("}");
        return sb;
    }

    private static void printBlock(Block block, int space, StringBuilder sb) {
        int i = 0;
        while (i < space) {
            sb.append("\t");
            ++i;
        }
        block.writeInfo(sb);
    }

    void saveImage(String fileName) {
        byte[] buf = this.mode.getImage();
        BufferedImage img = GLDataUtil.byteToImage(buf, this.mode.getWidth(), this.mode.getHeight());
        try {
            ImageIO.write((RenderedImage)img, "png", new File(fileName + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

