/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.MachineChecker;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.ConnectionBlock;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.system.edit.IdentManager;
import net.comp_lot.craftalos.system.edit.MachineWriter;
import net.comp_lot.glui.model.utils.RayCast;

class MachineManager {
    private final MachineWriter writer;
    private Machine machine;
    private MachineChecker machineChecker;
    private final List<Pair<ConnectionBlock, Part>> partsList = new ArrayList<Pair<ConnectionBlock, Part>>();
    private final IdentManager identManager = new IdentManager();

    public MachineManager(MachineWriter writer) {
        this.writer = writer;
    }

    public IdentManager getIdentManager() {
        return this.identManager;
    }

    public List<Pair<ConnectionBlock, Part>> getPartsList() {
        return this.partsList;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
        this.initMachine();
    }

    private void initMachine() {
        this.partsList.clear();
        this.identManager.clear();
        this.machineChecker = new MachineChecker(this.machine);
        if (this.machine.countPart() == 0) {
            Part p = new Part(this.machine);
            this.partsList.add(new Pair<Object, Part>(null, p));
            this.machine.addPart(p);
        } else {
            this.partsList.add(new Pair<Object, Part>(null, this.machine.getRootPart()));
            this.initAddParts((Part)this.partsList.get((int)0).value);
            this.machine.getFunctionalBlocks().stream().filter(fb -> fb != null).forEach(fb -> this.identManager.add(fb.getIdent()));
        }
    }

    private void initAddParts(Part part) {
        part.setColorType(true, true);
        part.getAllBlocks().forEach(block -> {
            if (block instanceof ConnectionBlock) {
                ConnectionBlock c = (ConnectionBlock)block;
                this.partsList.add(new Pair<ConnectionBlock, Part>(c, c.getChild()));
                this.initAddParts(c.getChild());
            }
        });
    }

    public MachineChecker getMachineChecker() {
        return this.machineChecker;
    }

    public String makeString() {
        return this.writer.makeString(this.machine, this.partsList);
    }

    public boolean saveModel(String fileName) {
        return this.writer.saveModel(this.machine, this.partsList, fileName);
    }

    public void addToPartsList(Part p) {
        p.getAllBlocks().stream().filter(b -> b instanceof FunctionalBlock).forEach(b -> {
            FunctionalBlock fb = (FunctionalBlock)b;
            if (this.identManager.contains(fb.getIdent())) {
                this.identManager.setIdent(fb);
            }
        });
        p.getAllBlocks().stream().filter(b -> b instanceof ConnectionBlock).forEach(b -> {
            ConnectionBlock c = (ConnectionBlock)b;
            this.partsList.add(new Pair<ConnectionBlock, Part>(c, c.getChild()));
        });
        p.getChildren().stream().forEach(m -> this.addToPartsList((Part)m));
    }

    public void removeFunctionalBlock(FunctionalBlock b) {
        this.identManager.remove(b.getIdent());
        if (b instanceof ConnectionBlock) {
            int i = 0;
            while (i < this.partsList.size()) {
                if (this.partsList.get((int)i).key == b) {
                    Part remove = (Part)this.partsList.remove((int)i).value;
                    remove.getAllBlocks().stream().filter(c -> c instanceof FunctionalBlock).forEach(c -> this.removeFunctionalBlock((FunctionalBlock)c));
                    ((Part)remove.getParent()).removePart(remove);
                    this.machine.removeMachinePart(remove);
                    break;
                }
                ++i;
            }
        }
    }

    public Part getPartByRayCast(RayCast.CastResult r) {
        Block block = ((Part)r.shape.getOwner()).getBlockByShape(r.shape);
        int partsNum = -1;
        if (block instanceof ConnectionBlock && ((ConnectionBlock)block).isConnectionFace(r.faceIndex)) {
            int i = 0;
            while (i < this.partsList.size()) {
                if (this.partsList.get((int)i).key == block) {
                    partsNum = i;
                }
                ++i;
            }
        } else {
            Part parts = (Part)r.shape.getOwner();
            int i = 0;
            while (i < this.partsList.size()) {
                if (this.partsList.get((int)i).value == parts) {
                    partsNum = i;
                }
                ++i;
            }
        }
        return partsNum < 0 ? null : (Part)this.partsList.get((int)partsNum).value;
    }

    public void rename(FunctionalBlock block, String oldName, String newName) {
        this.identManager.remove(oldName);
        if (!this.identManager.contains(newName)) {
            this.identManager.setIdent(block, newName);
        } else {
            this.identManager.setIdent(block, this.identManager.getIdent(newName + "_"));
        }
    }

    public void addConnectionBlock(ConnectionBlock connectionBlock) {
        this.getMachine().addMachinePart(connectionBlock.getChild());
        this.getPartsList().add(new Pair<ConnectionBlock, Part>(connectionBlock, connectionBlock.getChild()));
    }

    public ConnectionBlock getConnectionBlock(Part part) {
        int i = 0;
        while (i < this.getPartsList().size()) {
            if (this.getPartsList().get((int)i).value == part) {
                return (ConnectionBlock)this.getPartsList().get((int)i).key;
            }
            ++i;
        }
        return null;
    }

    static class Pair<K, V> {
        final K key;
        final V value;

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

