/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import net.comp_lot.craftalos.EditModeKeyConfig;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.edit.AlignCornerLayout;
import net.comp_lot.craftalos.system.edit.BlockFactory;
import net.comp_lot.craftalos.system.edit.CrossBarSelecter;
import net.comp_lot.craftalos.system.edit.EditMode;
import net.comp_lot.craftalos.system.edit.EditModeDescriptionManager;
import net.comp_lot.glui.system.utils.GluiXMLLayoutParser;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.AlignmentLayout;
import net.comp_lot.ui.layout.FrameLayout;
import net.comp_lot.ui.layout.HorizontalLinearLayout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

class EditModeUI {
    private final UIDisplay uiDisplay;
    private final AlignmentLayout rootLayout;
    private final Label nameLabel;
    private final Label selectedPartsLabel;
    private final Label blockNumLabel;
    private final Label partsNumLabel;
    private final Label weightLabel;
    private long saveLabelTime = 0L;
    private final Label saveLabel;
    private final Label mirrorLabel;
    private final Layout blockUIArea;
    private final Layout selectedFrame;
    private final Label[][] blockComponents;
    private final Label[][] colorComponents;
    private final Layout blockDescriptionFrame;
    private final Layout blockDescription;
    private final EditModeDescriptionManager descriptionManager;

    EditModeUI(UIDisplay uiDisplay, CrossBarSelecter<BlockFactory> blockSelecter, CrossBarSelecter<String> colorSelecter, EditModeKeyConfig keyConfig) {
        this.uiDisplay = uiDisplay;
        this.rootLayout = (AlignmentLayout)new GluiXMLLayoutParser().parseOrElse((DisplayInfo)uiDisplay, this.getClass().getResourceAsStream("edit_mode_layout.xml"), () -> null);
        this.nameLabel = new Label(uiDisplay, 30);
        this.selectedPartsLabel = (Label)this.rootLayout.getComponentByName("selected-parts-label");
        this.blockNumLabel = (Label)this.rootLayout.getComponentByName("block-num-label");
        this.partsNumLabel = (Label)this.rootLayout.getComponentByName("parts-num-label");
        this.weightLabel = (Label)this.rootLayout.getComponentByName("weight-label");
        this.saveLabel = new Label(uiDisplay, 30);
        this.mirrorLabel = (Label)this.rootLayout.getComponentByName("mirror-label");
        this.blockUIArea = (Layout)this.rootLayout.getComponentByName("block-ui-frame");
        this.selectedFrame = new FrameLayout(uiDisplay);
        this.selectedFrame.setBackground(new Background((DisplayInfo)uiDisplay, UIColor.ASH.code()));
        this.blockDescriptionFrame = (Layout)this.rootLayout.getComponentByName("block-description-frame");
        this.blockDescription = new VerticalLinearLayout(uiDisplay, 0);
        this.blockComponents = new Label[blockSelecter.getWidth()][];
        int i = 0;
        while (i < blockSelecter.getWidth()) {
            this.blockComponents[i] = new Label[blockSelecter.getHeight(i)];
            ++i;
        }
        this.colorComponents = new Label[colorSelecter.getWidth()][];
        i = 0;
        while (i < colorSelecter.getWidth()) {
            this.colorComponents[i] = new Label[colorSelecter.getHeight(i)];
            ++i;
        }
        this.descriptionManager = new EditModeDescriptionManager(uiDisplay, (Layout)this.rootLayout.getComponentByName("op-layout"), keyConfig);
        this.init(blockSelecter);
    }

    private void init(CrossBarSelecter<BlockFactory> blockSelecter) {
        AlignCornerLayout offset = new AlignCornerLayout(this.uiDisplay);
        offset.add(this.nameLabel);
        this.nameLabel.setMargin(10);
        ((Layout)this.rootLayout.getComponentByName("center-frame")).add(offset);
        this.saveLabel.setText(StringManager.lang.editModelSaved());
        this.saveLabel.setMargin(30);
        this.initBlockUIArea(blockSelecter);
        this.initColorUIArea();
        this.blockDescription.setPadding(15);
        this.blockDescription.setBackground(new Background((DisplayInfo)this.uiDisplay, UIColor.DARK_GRAY, UIColor.WHITE, 1));
    }

    private void initBlockUIArea(CrossBarSelecter<BlockFactory> blockSelecter) {
        int i = 0;
        while (i < this.blockComponents.length) {
            int j = 0;
            while (j < this.blockComponents[i].length) {
                Label label = new Label(this.uiDisplay, 40);
                label.setMargin(4);
                label.setBackground(UIColor.DARK_GRAY.code());
                label.setText(blockSelecter.get(i, j).create(null).getFactoryName());
                this.blockComponents[i][j] = label;
                ++j;
            }
            ++i;
        }
    }

    private void initColorUIArea() {
        int i = 0;
        while (i < this.colorComponents.length) {
            int j = 0;
            while (j < this.colorComponents[i].length) {
                Label label = new Label(this.uiDisplay, 40);
                label.setMargin(4);
                label.setBackground(UIColor.values()[j].code());
                label.setText("        ");
                this.colorComponents[i][j] = label;
                ++j;
            }
            ++i;
        }
    }

    Layout getRootLayout() {
        return this.rootLayout;
    }

    void updateOperationDescription(EditMode.Mode mode, boolean select, boolean rotate) {
        this.descriptionManager.updateOperationDescription(mode, select, rotate);
    }

    void setSelectedParts(String name) {
        String text = name != null ? name : "ROOT";
        this.selectedPartsLabel.setText(text);
    }

    void setName(String name) {
        this.nameLabel.setText(name);
        this.nameLabel.setVisible(name.length() != 0);
    }

    void updateInfo(int blockNum, int partsNum, int weight) {
        this.blockNumLabel.setText(blockNum + " blocks");
        this.partsNumLabel.setText(partsNum + " parts");
        this.weightLabel.setText(weight > 750 ? weight + " g!" : weight + " g");
    }

    void setBlockDescription(String text) {
        if (text.isEmpty()) {
            this.blockDescriptionFrame.remove(this.blockDescription);
        } else {
            this.blockDescription.clear();
            text.lines().forEach(line -> {
                Label label = new Label(this.uiDisplay, 30, (String)line);
                if (line.isEmpty()) {
                    label.setFontSize(7);
                }
                this.blockDescription.add(label);
            });
            this.blockDescriptionFrame.add(this.blockDescription);
        }
    }

    void showSaveLabel() {
        if (this.saveLabelTime == 0L) {
            this.saveLabelTime = System.currentTimeMillis() + 2000L;
            this.rootLayout.add(this.saveLabel);
            this.rootLayout.setVerticalAlign(this.saveLabel, AlignmentLayout.VERTICAL_TOP);
        }
    }

    void updateSaveLabel() {
        if (this.saveLabelTime > 0L && this.saveLabelTime < System.currentTimeMillis()) {
            this.rootLayout.remove(this.saveLabel);
            this.saveLabelTime = 0L;
        }
    }

    void setMirrorLabel(String text) {
        this.mirrorLabel.setText(text);
    }

    void drawBlockArea(boolean open, int blockTypeX, int[] blockTypeY) {
        this.drawBottomArea(this.blockComponents, open, blockTypeX, blockTypeY);
    }

    void drawColorArea(boolean open, int blockTypeX, int[] blockTypeY) {
        this.drawBottomArea(this.colorComponents, open, blockTypeX, blockTypeY);
    }

    private void drawBottomArea(Label[][] labels, boolean open, int selectedX, int[] selectedY) {
        this.blockUIArea.clear();
        if (open) {
            HorizontalLinearLayout horizontal = new HorizontalLinearLayout(this.uiDisplay, 2);
            horizontal.setAlign(HorizontalLinearLayout.BOTTOM);
            int x = 0;
            while (x < labels.length) {
                VerticalLinearLayout vertical = new VerticalLinearLayout(this.uiDisplay, 2);
                vertical.setAlign(VerticalLinearLayout.CENTER);
                vertical.setReverse(true);
                horizontal.add(vertical);
                if (x == selectedX) {
                    int j = 0;
                    while (j < labels[x].length) {
                        int y = (selectedY[x] + labels[x].length + j) % labels[x].length;
                        if (y == selectedY[x]) {
                            labels[x][y].setFontSize(40);
                            this.selectedFrame.clear();
                            this.selectedFrame.add(labels[x][y]);
                            vertical.add(this.selectedFrame);
                        } else {
                            labels[x][y].setFontSize(28);
                            vertical.add(labels[x][y]);
                        }
                        ++j;
                    }
                } else {
                    labels[x][selectedY[x]].setFontSize(28);
                    vertical.add(labels[x][selectedY[x]]);
                }
                ++x;
            }
            this.blockUIArea.add(horizontal);
        } else {
            this.blockUIArea.add(labels[selectedX][selectedY[selectedX]]);
        }
    }
}

