/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import net.comp_lot.craftalos.EditModeKeyConfig;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.edit.EditMode;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.Layout;

class EditModeDescriptionManager {
    private final UIDisplay uiDisplay;
    private final Layout opLayout;
    private final EditModeKeyConfig keyConfig;

    EditModeDescriptionManager(UIDisplay uiDisplay, Layout opLayout, EditModeKeyConfig keyConfig) {
        this.uiDisplay = uiDisplay;
        this.opLayout = opLayout;
        this.keyConfig = keyConfig;
    }

    void updateOperationDescription(EditMode.Mode mode, boolean select, boolean rotate) {
        this.opLayout.clear();
        if (rotate) {
            this.opDescriptionRotate();
        } else if (select) {
            if (mode == EditMode.Mode.BLOCK) {
                this.opDescriptionChangeBlock();
            } else if (mode == EditMode.Mode.COLOR) {
                this.opDescriptionChangeColor();
            }
        } else {
            switch (mode) {
                case BLOCK: {
                    this.opDescriptionEdit();
                    this.opDescriptionGeneral();
                    break;
                }
                case PARTS: {
                    this.opDescriptionPart();
                    break;
                }
                case COLOR: {
                    this.opDescriptionColor();
                    this.opDescriptionGeneral();
                    break;
                }
            }
        }
    }

    private void opDescriptionEdit() {
        this.addLabel(StringManager.lang.editPlaceKey(this.keyConfig.place().getShortName()));
        this.addLabel(StringManager.lang.editRemoveKey(this.keyConfig.remove().getShortName()));
        this.addLabel(StringManager.lang.editChangeBlockKey(this.keyConfig.blockChange().getShortName()));
        this.addLabel(StringManager.lang.editRotateKey(this.keyConfig.rotate().getShortName()));
        this.addLabel(StringManager.lang.editPartKey(this.keyConfig.partMove().getShortName()));
        this.addLabel(StringManager.lang.editCopyKey(this.keyConfig.partCopy().getShortName()));
        this.addLabel(StringManager.lang.editRenameKey(this.keyConfig.rename().getShortName()));
        this.addLabel(StringManager.lang.editPickerKey(this.keyConfig.picker().getShortName()));
        this.addLabel(StringManager.lang.editColorModeKey(this.keyConfig.modeColor().getShortName()));
    }

    private void opDescriptionPart() {
        this.addLabel(StringManager.lang.editPlaceKey(this.keyConfig.place().getShortName()));
        this.addLabel(StringManager.lang.editRemoveKey(this.keyConfig.remove().getShortName()));
        this.addLabel(StringManager.lang.editRotateKey(this.keyConfig.rotate().getShortName()));
        this.addLabel(StringManager.lang.editPartKey(this.keyConfig.partMove().getShortName()));
    }

    private void opDescriptionColor() {
        this.addLabel(StringManager.lang.editColorBlockKey(this.keyConfig.colorBlock().getShortName()));
        this.addLabel(StringManager.lang.editColorPartKey(this.keyConfig.colorPart().getShortName()));
        this.addLabel(StringManager.lang.editColorPickerKey(this.keyConfig.colorPicker().getShortName()));
        this.addLabel(StringManager.lang.editChangeColorKey(this.keyConfig.blockChange().getShortName()));
        this.addLabel(StringManager.lang.editEditModeKey(this.keyConfig.modeEdit().getShortName()));
    }

    private void opDescriptionRotate() {
        this.addLabel(StringManager.lang.editRotateKey("MOUSE_WHEEL"));
        this.addLabel(StringManager.lang.editRotateKey(OperationEvent.KeyCode.MOUSE_LEFT.getShortName()));
        this.addLabel(StringManager.lang.editRotateKey(OperationEvent.KeyCode.MOUSE_RIGHT.getShortName()));
    }

    private void opDescriptionChangeBlock() {
        this.addLabel(StringManager.lang.editChangeBlockKey("MOUSE_WHEEL"));
        this.addLabel(StringManager.lang.editChangeBlockKey(OperationEvent.KeyCode.MOUSE_LEFT.getShortName()));
        this.addLabel(StringManager.lang.editChangeBlockKey(OperationEvent.KeyCode.MOUSE_RIGHT.getShortName()));
    }

    private void opDescriptionChangeColor() {
        this.addLabel(StringManager.lang.editChangeColorKey("MOUSE_WHEEL"));
    }

    private void opDescriptionGeneral() {
        this.addLabel(StringManager.lang.editMirrorKey(this.keyConfig.mirror().getShortName()));
        this.addLabel(StringManager.lang.editUndoKey(this.keyConfig.undo().getShortName()));
        this.addLabel(StringManager.lang.editRedoKey(this.keyConfig.redo().getShortName()));
        this.addLabel(StringManager.lang.editSaveKey(this.keyConfig.save().getShortName()));
    }

    private void addLabel(String s) {
        Label label = new Label(this.uiDisplay, 30);
        label.setText(s);
        this.opLayout.add(label);
    }
}

