/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import java.io.FileNotFoundException;
import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.EditModeKeyConfig;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.ConnectionBlock;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.game.model.parts.CoreBlock;
import net.comp_lot.craftalos.game.model.parts.NormalBlock;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.craftalos.system.EditHistory;
import net.comp_lot.craftalos.system.EditableMode;
import net.comp_lot.craftalos.system.edit.BlockFactory;
import net.comp_lot.craftalos.system.edit.CrossBarSelecter;
import net.comp_lot.craftalos.system.edit.EditModeFloor;
import net.comp_lot.craftalos.system.edit.EditModeUI;
import net.comp_lot.craftalos.system.edit.MachineManager;
import net.comp_lot.craftalos.system.edit.MachineWriter;
import net.comp_lot.craftalos.system.edit.RenameMenu;
import net.comp_lot.craftalos.system.edit.RotationManager;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.camera.FlyingCamera;
import net.comp_lot.glui.model.CoordinateSystem;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.utils.RayCast;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.glui.system.utils.ObjParser;
import net.comp_lot.glui.ui.Image;
import net.comp_lot.ui.layout.CenterLayout;

public class EditMode
extends EditableMode {
    private static final Vector BLOCK_CENTER = new MutVector().set(1.0, 1.0, 1.0);
    private final MutVector mirrorCenter = new MutVector().set(BLOCK_CENTER);
    private final CraftalosConfig config;
    private final EditModeKeyConfig keyConfig;
    private final CrossBarSelecter<BlockFactory> blockSelecter = new CrossBarSelecter<BlockFactory>(new BlockFactory[][]{{new BlockFactory.NormalBlockFactory(1, 1), new BlockFactory.NormalBlockFactory(1, 2), new BlockFactory.NormalBlockFactory(1, 3), new BlockFactory.NormalBlockFactory(1, 4), new BlockFactory.NormalBlockFactory(1, 6), new BlockFactory.NormalBlockFactory(1, 8)}, {new BlockFactory.NormalBlockFactory(2, 2), new BlockFactory.NormalBlockFactory(2, 3), new BlockFactory.NormalBlockFactory(2, 4), new BlockFactory.NormalBlockFactory(2, 6), new BlockFactory.NormalBlockFactory(2, 8)}, {new BlockFactory.HalfBlockFactory(1, 1), new BlockFactory.HalfBlockFactory(1, 2), new BlockFactory.HalfBlockFactory(1, 3), new BlockFactory.HalfBlockFactory(1, 4), new BlockFactory.HalfBlockFactory(1, 6), new BlockFactory.HalfBlockFactory(1, 8)}, {new BlockFactory.HalfBlockFactory(2, 2), new BlockFactory.HalfBlockFactory(2, 3), new BlockFactory.HalfBlockFactory(2, 4), new BlockFactory.HalfBlockFactory(2, 6), new BlockFactory.HalfBlockFactory(2, 8)}, {new BlockFactory.MotorBlockFactory(), new BlockFactory.SuperMotorBlockFactory()}, {new BlockFactory.CoreBlockFactory(), new BlockFactory.CameraBlockFactory(), new BlockFactory.FcsBlockFactory(), new BlockFactory.LinkBlockFactory()}, {new BlockFactory.MouseAxisBlockFactory(), new BlockFactory.HorizontalBlockFactory(), new BlockFactory.LightSensorBlockFactory(), new BlockFactory.DistanceSensorBlockFactory(), new BlockFactory.SpeedSensorBlockFactory()}, {new BlockFactory.RifleBlockFactory(1), new BlockFactory.RifleBlockFactory(2), new BlockFactory.RifleBlockFactory(3), new BlockFactory.RifleBlockFactory(4), new BlockFactory.RifleBlockFactory(6), new BlockFactory.RifleBlockFactory(8), new BlockFactory.GrenadeBlockFactory(1), new BlockFactory.GrenadeBlockFactory(2), new BlockFactory.GrenadeBlockFactory(3), new BlockFactory.GrenadeBlockFactory(4), new BlockFactory.GrenadeBlockFactory(6), new BlockFactory.GrenadeBlockFactory(8), new BlockFactory.RailBlockFactory(2), new BlockFactory.RailBlockFactory(4), new BlockFactory.RailBlockFactory(6), new BlockFactory.RailBlockFactory(8), new BlockFactory.RailBlockFactory(12), new BlockFactory.RailBlockFactory(16), new BlockFactory.MachineGunBlockFactory(1), new BlockFactory.MachineGunBlockFactory(2), new BlockFactory.MachineGunBlockFactory(3), new BlockFactory.MachineGunBlockFactory(4), new BlockFactory.MachineGunBlockFactory(6), new BlockFactory.MachineGunBlockFactory(8)}});
    private final CrossBarSelecter<String> colorSelecter = new CrossBarSelecter<String>(new String[][]{{"#ffffff", "#424242", "#e13c56", "#78aa04", "#4a7dcf", "#7b4397", "#e16d3c", "#e0ae04"}});
    private final MutVector partsMoveAxisFront = new MutVector().set(0.0, 0.0, 1.0);
    private final MutVector partsMoveAxisSide = new MutVector().set(1.0, 0.0, 0.0);
    private final Vector rotateA = this.partsMoveAxisSide;
    private final Vector rotateB = this.partsMoveAxisFront;
    private final Vector rotateC = Vector.Y_AXIS;
    private int wheelNum = 0;
    private final FlyingCamera camera = new FlyingCamera(this, 0.3f);
    private final EditModeUI ui;
    private final EditHistory<String> hist;
    private final ModelGroup editModel = new ModelGroup();
    private final Shape mirrorLine = new BoxShape(0.3f, 0.05f, 72.0f, TextureEnum.WHITE.getAsInfo());
    private final Shape targetPoint = new BoxShape(0.2f, 0.2f, 0.2f, TextureEnum.WHITE.getAsInfo());
    private final Part targetPart = new Part(null);
    private Block targetBlock = null;
    private final CoordinateSystem blockCS = new CoordinateSystem(-1);
    private final CoordinateSystem mirrorCS = new CoordinateSystem(-1);
    private Part selectedPart = null;
    private Mode mode = Mode.BLOCK;
    private boolean mirror = false;
    private int colorOpen = 0;
    private final RotationManager rotationManager = new RotationManager();
    private final MachineManager machineManager = new MachineManager(new MachineWriter(this));

    public EditMode(Game game, String fileName) {
        super(game, false, Main.Mode.EDIT, fileName);
        this.config = (CraftalosConfig)game.getConfig();
        this.keyConfig = this.config.getEditModeKeyConfig();
        this.ui = new EditModeUI(this.uiDisplay, this.blockSelecter, this.colorSelecter, this.keyConfig);
        this.initUI();
        this.initEditMode();
        this.hist = new EditHistory<String>(this.machineManager.makeString());
        if (fileName.startsWith("res/")) {
            MenuManager menu = new MenuManager(this.uiDisplay);
            menu.set(StringManager.lang.gameMenuPath() + "cannot_write.md");
            menu.setListener("ok", args -> this.showMenu(null));
            this.showMenu(menu.getComponent());
        }
    }

    private void initUI() {
        Image cross = new Image(this.uiDisplay, TextureEnum.UI_EDIT_CENTER.getAsInfo());
        cross.setMinWidth(128);
        cross.setMinHeight(128);
        this.addRootUI(new CenterLayout(this.uiDisplay, cross));
        this.addUI(this.ui.getRootLayout());
        this.ui.setSelectedParts(null);
    }

    private void initEditMode() {
        String machineSource;
        this.camera.setKey(this.keyConfig.cameraForward(), this.keyConfig.cameraBackward(), this.keyConfig.cameraLeft(), this.keyConfig.cameraRight(), this.keyConfig.cameraUp(), this.keyConfig.cameraDown());
        this.camera.setSensitivity(this.config.getMouseSensitivity());
        this.camera.setPlace(new MutVector().set(-36.0, 36.0, 36.0));
        this.camera.setCameraAxis(new MutVector().set(Vector.Z_AXIS).rotate(Vector.X_AXIS, 0.5235987755982988).rotate(Vector.Y_AXIS, 2.356194490192345));
        this.mirrorLine.setColor(-16777088);
        this.mirrorLine.setOpaque(false);
        this.mirrorLine.setVisible(this.mirror);
        this.mainModel.addModels(this.mirrorLine);
        try {
            this.mainModel.addModels(new ObjParser("res/garage.obj", TextureEnum.WHITE.getAsInfo()).getModel());
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        this.mainModel.addModels(this.editModel);
        this.editModel.addModels(EditModeFloor.makeFloor());
        this.editModel.addModels(this.targetPart.getModel());
        try {
            machineSource = FileUtils.loadFile(this.getFileName() + ".bcm");
        }
        catch (FileNotFoundException e) {
            machineSource = "";
        }
        this.loadMachine(machineSource);
        this.setNewTargetBlock();
    }

    private void loadMachine(String source) {
        if (source == null) {
            return;
        }
        if (this.machineManager.getMachine() != null) {
            this.editModel.removeModel(this.machineManager.getMachine().getModel());
        }
        try {
            this.machineManager.setMachine(MachineCompiler.compile(source));
        }
        catch (CompileException e) {
            if (source.length() > 0) {
                System.err.println(e.getDetailMessage(source));
                this.showMessage(StringManager.lang.editFailedToLoadMachine());
            }
            this.machineManager.setMachine(new Machine());
        }
        this.selectedPart = null;
        this.selectParts((Part)this.machineManager.getPartsList().get((int)0).value);
        this.editModel.addModels(this.machineManager.getMachine().getModel());
        this.updateInfoText();
    }

    private void addHist() {
        this.hist.addHistory(this.machineManager.makeString());
    }

    private void selectParts(Part p) {
        if (this.selectedPart != null) {
            this.selectedPart.setColorType(true, true);
        }
        this.selectedPart = p;
        this.selectedPart.setColorType(true, false);
        this.ui.setSelectedParts(p.getConnectionIdent());
    }

    private void setNewTargetBlock() {
        if (this.targetBlock != null) {
            this.editModel.removeModel(this.targetBlock.getModel());
        }
        this.targetBlock = this.createNewBlock();
        this.mirrorCenter.set(this.targetBlock.getModel().getBound().getMaxX() - 1.0, 1.0, 1.0);
        this.targetBlock.getModel().setCoordinateSystem(this.blockCS);
        this.editModel.addModels(this.targetBlock.getModel());
    }

    private Block createNewBlock() {
        Block newBlock = this.blockSelecter.getSelected().create(this.machineManager.getMachine());
        newBlock.getModel().callConfirmCoordinate();
        newBlock.getModel().setBound();
        if (newBlock instanceof NormalBlock) {
            ((NormalBlock)newBlock).setColor(this.colorSelecter.getSelected());
        }
        newBlock.setColorType(false, false);
        return newBlock;
    }

    private void placeBlock() {
        this.editModel.callConfirmCoordinate();
        this.editModel.setBound();
        if (!this.machineManager.getMachineChecker().check(this.targetBlock.getModel())) {
            this.getGame().getAudioSystem().playSound(SoundEnum.COLLIDE.getId(), ((CraftalosConfig)this.getGame().getConfig()).getVolumeSe(), false);
            return;
        }
        if (this.targetBlock instanceof FunctionalBlock) {
            FunctionalBlock functionalBlock = (FunctionalBlock)this.targetBlock;
            this.machineManager.getIdentManager().setIdent(functionalBlock);
            if (functionalBlock instanceof CoreBlock && (this.selectedPart.getConnectionIdent() != null || !functionalBlock.getIdent().equals("CORE_0"))) {
                this.machineManager.getIdentManager().remove(functionalBlock.getIdent());
                this.getGame().getAudioSystem().playSound(SoundEnum.COLLIDE.getId(), ((CraftalosConfig)this.getGame().getConfig()).getVolumeSe(), false);
                return;
            }
        }
        this.getGame().getAudioSystem().playSound(SoundEnum.PLACE.getId(), ((CraftalosConfig)this.getGame().getConfig()).getVolumeSe(), false);
        this.selectedPart.addBlocks(this.targetBlock);
        this.targetBlock.setColorType(true, false);
        if (this.targetBlock instanceof ConnectionBlock) {
            this.selectedPart.addPart(((ConnectionBlock)this.targetBlock).getChild());
            this.machineManager.addConnectionBlock((ConnectionBlock)this.targetBlock);
        }
        this.setNewTargetBlock();
        this.updateInfoText();
        this.addHist();
    }

    private void removeBlock(Block b) {
        this.getGame().getAudioSystem().playSound(SoundEnum.DELETE.getId(), ((CraftalosConfig)this.getGame().getConfig()).getVolumeSe(), false);
        if (b instanceof FunctionalBlock) {
            this.machineManager.removeFunctionalBlock((FunctionalBlock)b);
            if (!this.machineManager.getPartsList().parallelStream().anyMatch(p -> p.value == this.selectedPart)) {
                this.selectParts((Part)this.machineManager.getPartsList().get((int)0).value);
            }
        }
        b.getPart().removeBlock(b);
        this.updateInfoText();
        this.addHist();
    }

    private void changeMode(boolean copy) {
        if (this.mode == Mode.BLOCK) {
            this.editModel.removeModel(this.targetBlock.getModel());
            Part.replaceAllChildren(this.selectedPart, this.targetPart);
            this.targetPart.setColorTypeRec(false, false);
            ConnectionBlock block = this.machineManager.getConnectionBlock(this.selectedPart);
            if (block != null) {
                this.editModel.callConfirmCoordinate();
                block.calcParentFixPoint();
                this.blockCS.setCenter(block.getConnectionPoint());
            } else {
                this.blockCS.setCenter(Vector.ZERO);
            }
            this.mode = Mode.PARTS;
        } else if (this.mode == Mode.PARTS) {
            if (!this.machineManager.getMachineChecker().check(this.targetPart.getModel())) {
                return;
            }
            this.machineManager.addToPartsList(this.targetPart);
            Part.replaceAllChildren(this.targetPart, this.selectedPart);
            this.blockCS.setCenter(Vector.ZERO);
            this.targetBlock.getModel().setCoordinateSystem(this.blockCS);
            this.editModel.addModels(this.targetBlock.getModel());
            this.mode = Mode.BLOCK;
        } else {
            return;
        }
        if (!copy) {
            this.addHist();
        }
        this.loadMachine(this.hist.getState());
        this.updateInfoText();
    }

    private void changeMode() {
        if (this.mode == Mode.BLOCK) {
            this.editModel.removeModel(this.targetBlock.getModel());
            this.colorOpen = 90;
            this.mode = Mode.COLOR;
        } else {
            this.setNewTargetBlock();
            this.mode = Mode.BLOCK;
        }
    }

    private void keyOperation() {
        if (this.getKeyState(this.keyConfig.machineMove())) {
            this.moveMachine(this.getMove());
        } else if (this.mode == Mode.PARTS) {
            this.movePart(this.getMove());
        }
        if (this.getKeyDown(this.keyConfig.save())) {
            this.callSave();
        }
        if (this.getKeyDown(this.keyConfig.undo())) {
            this.loadMachine(this.hist.undo());
        }
        if (this.getKeyDown(this.keyConfig.redo())) {
            this.loadMachine(this.hist.redo());
        }
        if (this.getKeyDown(this.keyConfig.partMove()) || this.mode == Mode.BLOCK && this.getKeyDown(this.keyConfig.partCopy())) {
            this.changeMode(this.mode == Mode.BLOCK && this.getKeyDown(this.keyConfig.partCopy()));
        }
        if (this.mode != Mode.COLOR && this.getKeyDown(this.keyConfig.modeColor()) || this.mode == Mode.COLOR && this.getKeyDown(this.keyConfig.modeEdit())) {
            if (this.mode == Mode.PARTS) {
                this.targetPart.clear();
                this.changeMode(false);
            }
            this.changeMode();
        }
        if (this.getKeyDown(this.keyConfig.mirror())) {
            this.mirror = !this.mirror;
            this.ui.setMirrorLabel(this.mirror ? StringManager.lang.editMirrorEnable() : "");
            this.mirrorLine.setVisible(this.mirror);
        }
    }

    @Override
    protected boolean save() {
        if (!this.machineManager.getMachineChecker().check()) {
            this.showMessage(this.machineManager.getMachineChecker().getMessage());
        }
        if (this.machineManager.saveModel(this.getFileName())) {
            this.hist.markSaved();
            this.ui.showSaveLabel();
            return true;
        }
        MenuManager menu = new MenuManager(this.uiDisplay);
        menu.setGetter("$message", args -> "something happen");
        menu.set(StringManager.lang.gameMenuPath() + "save_failed.md");
        menu.setListener("ok", args -> this.showMenu(null));
        this.showMenu(menu.getComponent());
        return false;
    }

    private void moveMachine(Vector move) {
        if (move.getSize() > 0.0) {
            this.machineManager.getMachine().getModel().moveShapes(move, 1.0);
            this.addHist();
        }
    }

    private void movePart(Vector move) {
        if (move.getSize() > 0.0) {
            this.targetPart.getModel().moveShapes(move, 1.0);
        }
    }

    private Vector getMove() {
        MutVector v = new MutVector().set(Vector.ZERO);
        if (this.getKeyDown(this.keyConfig.moveForward())) {
            v.add(this.partsMoveAxisFront, 1.0);
        }
        if (this.getKeyDown(this.keyConfig.moveBackward())) {
            v.add(this.partsMoveAxisFront, -1.0);
        }
        if (this.getKeyDown(this.keyConfig.moveLeft())) {
            v.add(this.partsMoveAxisSide, -1.0);
        }
        if (this.getKeyDown(this.keyConfig.moveRight())) {
            v.add(this.partsMoveAxisSide, 1.0);
        }
        if (this.getKeyDown(this.keyConfig.moveUp())) {
            v.add(Vector.Y_AXIS, 1.0);
        }
        if (this.getKeyDown(this.keyConfig.moveDown())) {
            v.add(Vector.Y_AXIS, -1.0);
        }
        return v;
    }

    private void mouseWheelOperation() {
        if (this.mode == Mode.COLOR) {
            if (this.wheelNum != 0) {
                this.colorSelecter.move(0, this.wheelNum);
                this.colorOpen = 60;
            }
        } else if (this.getKeyState(this.keyConfig.blockChange())) {
            if (this.mode == Mode.BLOCK) {
                if (this.wheelNum != 0) {
                    this.blockSelecter.move(0, this.wheelNum);
                }
                if (this.getKeyDown(OperationEvent.KeyCode.KEY_UP)) {
                    this.blockSelecter.move(0, 1);
                }
                if (this.getKeyDown(OperationEvent.KeyCode.KEY_DOWN)) {
                    this.blockSelecter.move(0, -1);
                }
                if (this.getKeyDown(OperationEvent.KeyCode.MOUSE_LEFT) || this.getKeyDown(OperationEvent.KeyCode.KEY_LEFT)) {
                    this.blockSelecter.move(-1, 0);
                }
                if (this.getKeyDown(OperationEvent.KeyCode.MOUSE_RIGHT) || this.getKeyDown(OperationEvent.KeyCode.KEY_RIGHT)) {
                    this.blockSelecter.move(1, 0);
                }
                this.setNewTargetBlock();
            }
        } else if (this.getKeyState(this.keyConfig.rotate())) {
            if (this.wheelNum != 0) {
                this.rotate(this.rotateA, (double)this.wheelNum * Math.PI / 2.0);
            }
            if (this.getKeyDown(OperationEvent.KeyCode.KEY_UP)) {
                this.rotate(this.rotateA, 1.5707963267948966);
            }
            if (this.getKeyDown(OperationEvent.KeyCode.KEY_DOWN)) {
                this.rotate(this.rotateA, -1.5707963267948966);
            }
            if (this.getKeyDown(OperationEvent.KeyCode.MOUSE_LEFT) || this.getKeyDown(OperationEvent.KeyCode.KEY_LEFT)) {
                this.rotate(this.rotateB, -1.5707963267948966);
            }
            if (this.getKeyDown(OperationEvent.KeyCode.MOUSE_RIGHT) || this.getKeyDown(OperationEvent.KeyCode.KEY_RIGHT)) {
                this.rotate(this.rotateC, 1.5707963267948966);
            }
        } else if (this.mode == Mode.PARTS && this.wheelNum != 0) {
            this.targetPart.getModel().moveShapes(this.partsMoveAxisFront, this.wheelNum);
        }
        this.wheelNum = 0;
    }

    private void rotate(Vector axis, double angle) {
        if (this.rotationManager.isRotating()) {
            this.rotationManager.setSkip();
            this.animateRotation();
        }
        MutVector center = new MutVector();
        if (this.mode == Mode.PARTS) {
            center.set(this.blockCS.getCenter());
        } else {
            this.blockCS.LocalToParentCoord(center, BLOCK_CENTER);
        }
        this.rotationManager.setRotation(center, axis, angle, 5);
    }

    private void animateRotation() {
        if (this.mode == Mode.PARTS) {
            this.rotationManager.animatePart(this.targetPart);
        } else {
            this.rotationManager.animateCoordinateSystem(this.blockCS, this.mirrorCS);
            this.targetBlock.getModel().setCoordinateSystem(this.blockCS);
        }
    }

    private void mouseTargetOperation() {
        this.editModel.removeModel(this.targetPoint);
        RayCast cast = new RayCast(this.camera.getCamera(), this.camera.getCameraAxis(), 100.0);
        RayCast.CastResult r = cast.cast(this.editModel, this.mode == Mode.BLOCK ? this.targetBlock.getModel() : this.targetPart.getModel());
        this.showBlockName(r);
        if (r != null) {
            MutVector p = new MutVector().set(r.point).round();
            this.targetPoint.setPosition(p);
            this.editModel.addModels(this.targetPoint);
            if (!this.isInMenu()) {
                if (r.shape.getOwner() != null && r.shape.getOwner() != this.targetPart) {
                    this.selectPartByRayCast(r);
                }
                MutVector mirrorNormal = new MutVector().set(-r.getNormal().getX(), r.getNormal().getY(), r.getNormal().getZ());
                RayCast mirrorCast = new RayCast(new MutVector().set(-r.point.getX(), r.point.getY(), r.point.getZ()).add(mirrorNormal, 0.5), new MutVector().set(mirrorNormal).reverse(), 1.0);
                RayCast.CastResult mirrorResult = mirrorCast.cast(this.editModel, this.targetBlock.getModel());
                if (this.mode == Mode.PARTS) {
                    this.mouseTargetOperationParts(p, r);
                } else if (this.mode == Mode.BLOCK) {
                    this.mouseTargetOperationBlock(p, r, mirrorResult, mirrorNormal);
                } else if (this.mode == Mode.COLOR && r.shape.getOwner() != null) {
                    this.mouseTargetOperationColor(r);
                    if (this.mirror && mirrorResult != null && mirrorResult.shape.getOwner() != null) {
                        this.mouseTargetOperationColor(mirrorResult);
                    }
                }
            }
        }
    }

    private void showBlockName(RayCast.CastResult r) {
        Block block;
        if (r != null && r.shape.getOwner() != null && (block = ((Part)r.shape.getOwner()).getBlockByShape(r.shape)) instanceof FunctionalBlock && ((FunctionalBlock)block).getIdent() != null) {
            this.ui.setName(((FunctionalBlock)block).getIdent());
            if (this.getKeyDown(this.keyConfig.rename())) {
                this.rename((FunctionalBlock)block);
            }
            return;
        }
        this.ui.setName("");
    }

    private void rename(FunctionalBlock block) {
        String oldName = block.getIdent();
        new RenameMenu(this).show(oldName, newName -> {
            this.machineManager.rename(block, oldName, (String)newName);
            if (!block.getIdent().equals(oldName)) {
                this.addHist();
            }
        });
    }

    private void selectPartByRayCast(RayCast.CastResult r) {
        Part castPart = this.machineManager.getPartByRayCast(r);
        if (castPart != null && castPart != this.selectedPart) {
            this.selectParts(castPart);
        }
    }

    private void mouseTargetOperationColor(RayCast.CastResult r) {
        if (!this.getKeyState(this.keyConfig.blockChange()) && !this.getKeyState(this.keyConfig.rotate())) {
            Part parent = (Part)r.shape.getOwner();
            Block block = parent.getBlockByShape(r.shape);
            if (this.getKeyDown(this.keyConfig.colorBlock()) && block instanceof NormalBlock) {
                ((NormalBlock)block).setColor(this.colorSelecter.getSelected());
                this.addHist();
            }
            if (this.getKeyDown(this.keyConfig.colorPart())) {
                parent.getAllBlocks().forEach(child -> {
                    if (child instanceof NormalBlock) {
                        ((NormalBlock)child).setColor(this.colorSelecter.getSelected());
                    }
                });
                this.addHist();
            }
            if (this.getKeyDown(this.keyConfig.colorPicker()) && block instanceof NormalBlock) {
                String color = ((NormalBlock)block).getColor();
                this.colorSelecter.select(t -> t.equals(color));
            }
        }
    }

    private void mouseTargetOperationParts(Vector p, RayCast.CastResult r) {
        this.targetPart.getModel().moveShapes(this.blockCS.getCenter(), -1.0);
        this.blockCS.setCenter(p);
        this.blockCS.move(r.shape.getFacesArray()[r.faceIndex].getNormal(), 1.0);
        this.targetPart.getModel().moveShapes(this.blockCS.getCenter(), 1.0);
        if (!this.getKeyState(this.keyConfig.blockChange()) && !this.getKeyState(this.keyConfig.rotate())) {
            if (this.getKeyDown(this.keyConfig.place())) {
                this.changeMode(false);
            } else if (this.getKeyDown(this.keyConfig.remove())) {
                this.targetPart.clear();
                this.changeMode(false);
            }
        }
    }

    private void mouseTargetOperationBlock(Vector p, RayCast.CastResult r, RayCast.CastResult mr, Vector mn) {
        MutVector center = new MutVector();
        this.blockCS.LocalToParent(center, BLOCK_CENTER);
        this.blockCS.setCenter(center.reverse().add(p).add(r.getNormal()));
        this.targetBlock.getModel().setCoordinateSystem(this.blockCS);
        if (!this.getKeyState(this.keyConfig.blockChange()) && !this.getKeyState(this.keyConfig.rotate())) {
            if (this.getKeyDown(this.keyConfig.place())) {
                this.placeBlock();
                if (this.mirror) {
                    if (mr != null && mr.shape.getOwner() != null) {
                        this.selectPartByRayCast(mr);
                    }
                    this.placeMirror(p, mn);
                }
            } else if (this.getKeyDown(this.keyConfig.remove()) && r.shape.getOwner() != null) {
                this.removeBlock(((Part)r.shape.getOwner()).getBlockByShape(r.shape));
                if (this.mirror && mr != null && r.shape != mr.shape && mr.shape.getOwner() != null) {
                    this.removeBlock(((Part)mr.shape.getOwner()).getBlockByShape(mr.shape));
                }
            }
            if (this.getKeyDown(this.keyConfig.picker()) && r.shape.getOwner() != null) {
                Block block = ((Part)r.shape.getOwner()).getBlockByShape(r.shape);
                this.blockSelecter.select(bf -> bf.create(null).getFactoryName().equals(block.getFactoryName()));
                if (block instanceof NormalBlock) {
                    String color = ((NormalBlock)block).getColor();
                    this.colorSelecter.select(t -> t.equals(color));
                }
                this.setNewTargetBlock();
            }
        }
    }

    private void placeMirror(Vector p, Vector mn) {
        MutVector offset = new MutVector();
        this.mirrorCS.LocalToParent(offset, this.mirrorCenter);
        this.mirrorCS.setCenter(new MutVector().set(-p.getX(), p.getY(), p.getZ()).add(mn).add(offset, -1.0));
        this.targetBlock.getModel().setCoordinateSystem(this.mirrorCS);
        this.placeBlock();
    }

    @Override
    protected void onMouseMove(float x, float y) {
        if (!this.isInMenu()) {
            this.camera.onMouseMove(x, y);
        }
    }

    @Override
    protected void onMouseScroll(double size) {
        if (!this.isInMenu()) {
            this.wheelNum = (int)((double)this.wheelNum + size);
        }
    }

    @Override
    protected void onFrame() {
        super.onFrame();
        this.camera.onFrame();
        this.setCamera(this.camera.getCamera(), this.camera.getCameraAxis(), Vector.Y_AXIS);
        if (this.rotationManager.isRotating()) {
            this.animateRotation();
        } else {
            this.setMoveAxis();
            this.mouseTargetOperation();
            this.mouseWheelOperation();
            this.keyOperation();
        }
        this.updateGUI();
        this.editModel.callConfirmCoordinate();
        this.editModel.setBound();
    }

    private void updateGUI() {
        this.ui.setBlockDescription("");
        if (this.mode == Mode.BLOCK) {
            this.ui.drawBlockArea(this.getKeyState(this.keyConfig.blockChange()), this.blockSelecter.getX(), this.blockSelecter.getY());
            if (this.getKeyState(this.keyConfig.blockChange())) {
                this.ui.setBlockDescription(this.blockSelecter.getSelected().getDescription());
            }
        } else if (this.mode == Mode.COLOR) {
            if (this.getKeyState(this.keyConfig.blockChange())) {
                this.colorOpen = 1;
            }
            this.ui.drawColorArea(this.colorOpen > 0, this.colorSelecter.getX(), this.colorSelecter.getY());
            if (this.colorOpen > 0) {
                --this.colorOpen;
            }
        }
        this.ui.updateOperationDescription(this.mode, (this.mode == Mode.BLOCK || this.mode == Mode.COLOR) && this.getKeyState(this.keyConfig.blockChange()), (this.mode == Mode.BLOCK || this.mode == Mode.PARTS) && this.getKeyState(this.keyConfig.rotate()));
        this.ui.updateSaveLabel();
    }

    private void setMoveAxis() {
        this.partsMoveAxisFront.set(this.camera.getCameraAxis().getX(), 0.0, this.camera.getCameraAxis().getZ()).mainDirection().resize(1.0);
        this.partsMoveAxisSide.set(this.partsMoveAxisFront).rotate(Vector.Y_AXIS, 1.5707963267948966).mainDirection().resize(1.0);
    }

    private void updateInfoText() {
        this.ui.updateInfo(this.machineManager.getMachine().countBlock(), this.machineManager.getMachine().countPart(), this.machineManager.getMachine().countWeight());
    }

    @Override
    protected boolean isUpdated() {
        return this.hist.isUpdated();
    }

    static enum Mode {
        BLOCK,
        PARTS,
        COLOR;

    }
}

