/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import java.util.function.Function;

public class CrossBarSelecter<T> {
    private final T[][] target;
    private int selectedX;
    private int[] selectedY;

    public CrossBarSelecter(T[][] target) {
        this.target = target;
        this.selectedY = new int[this.getWidth()];
    }

    public void move(int x, int y) {
        this.selectedX = (this.selectedX + x + this.getWidth()) % this.getWidth();
        this.selectedY[this.selectedX] = (this.selectedY[this.selectedX] + y + this.getHeight(this.selectedX)) % this.getHeight(this.selectedX);
    }

    public boolean select(Function<T, Boolean> selector) {
        int x = 0;
        while (x < this.target.length) {
            int y = 0;
            while (y < this.target[x].length) {
                if (selector.apply(this.target[x][y]).booleanValue()) {
                    this.selectedX = x;
                    this.selectedY[x] = y;
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public T get(int x, int y) {
        return this.target[x][y];
    }

    public T getSelected() {
        return this.target[this.selectedX][this.selectedY[this.selectedX]];
    }

    public int getX() {
        return this.selectedX;
    }

    public int[] getY() {
        return this.selectedY;
    }

    public int getWidth() {
        return this.target.length;
    }

    public int getHeight(int x) {
        return this.target[x].length;
    }
}

