/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.edit;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.entity.Bullet;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.WeaponBlock;
import net.comp_lot.craftalos.game.model.parts.CameraBlock;
import net.comp_lot.craftalos.game.model.parts.CoreBlock;
import net.comp_lot.craftalos.game.model.parts.DistanceSensorBlock;
import net.comp_lot.craftalos.game.model.parts.FcsBlock;
import net.comp_lot.craftalos.game.model.parts.GrenadeBlock;
import net.comp_lot.craftalos.game.model.parts.HorizontalBlock;
import net.comp_lot.craftalos.game.model.parts.LightSensorBlock;
import net.comp_lot.craftalos.game.model.parts.LinkBlock;
import net.comp_lot.craftalos.game.model.parts.MachineGunBlock;
import net.comp_lot.craftalos.game.model.parts.MotorBlock;
import net.comp_lot.craftalos.game.model.parts.MouseAxisBlock;
import net.comp_lot.craftalos.game.model.parts.NormalBlock;
import net.comp_lot.craftalos.game.model.parts.RailBlock;
import net.comp_lot.craftalos.game.model.parts.RifleBlock;
import net.comp_lot.craftalos.game.model.parts.SpeedSensorBlock;
import net.comp_lot.craftalos.game.model.parts.SuperMotorBlock;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;

interface BlockFactory {
    public Block create(Machine var1);

    default public String getDescription() {
        Block b = this.create(null);
        return String.format("%s\n------------------------------------------------------------\n\u91cd\u91cf: %.2f\n\u8010\u4e45\u5024: %.2f\n", b.getFactoryName(), (double)b.getWeight() + 0.0, b.getInitialEndurance());
    }

    public static class CameraBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new CameraBlock(machine, null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u7dd1\u306e\u9762\u304c\u30ab\u30e1\u30e9\u306b\u306a\u3063\u3066\u3044\u308b\n\u30d7\u30ed\u30b0\u30e9\u30e0\u30670\u4ee5\u5916\u3092\u8a2d\u5b9a\u3059\u308b\u3068\u30ab\u30e1\u30e9\u304c\u5207\u308a\u66ff\u308f\u308b";
        }
    }

    public static class CoreBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new CoreBlock(null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u6a5f\u4f53\u306e\u30b3\u30a2\u3068\u306a\u308b\u30d6\u30ed\u30c3\u30af\n\u3061\u3087\u3046\u30691\u3064\u4f7f\u3046\u5fc5\u8981\u304c\u3042\u308b";
        }
    }

    public static class DistanceSensorBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new DistanceSensorBlock(machine, null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u7d2b\u306e\u9762\u306e\u5148\u306b\u3042\u308b\u3082\u306e\u3078\u306e\u8ddd\u96e2\u3092\u8abf\u3079\u308b";
        }
    }

    public static class FcsBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new FcsBlock(machine, null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u706b\u5668\u7ba1\u5236\u3092\u884c\u3046\u305f\u3081\u306e\u30d6\u30ed\u30c3\u30af\n\u30d7\u30ed\u30b0\u30e9\u30e0\u30670\u4ee5\u5916\u3092\u8a2d\u5b9a\u3059\u308b\u3068\u5f3e\u9053\u4e88\u6e2c\u7dda\u304c\u8868\u793a\u3055\u308c\u308b";
        }
    }

    public static class GrenadeBlockFactory
    extends WeaponFactory {
        private final int length;

        GrenadeBlockFactory(int length) {
            this.length = length;
        }

        @Override
        public Block create(Machine machine) {
            return new GrenadeBlock(machine, null, this.length);
        }

        @Override
        protected String getDescription(WeaponBlock weapon, Bullet bullet, double reload) {
            return String.format("\u5a01\u529b: %.2f\n\u30ea\u30ed\u30fc\u30c9: %.2f\n\u5f3e\u901f: %.2f\n", 60.0, reload, bullet.getSpeed().getSize()) + "\n\u7206\u767a\u3059\u308b\u6b66\u5668";
        }
    }

    public static class HalfBlockFactory
    implements BlockFactory {
        private final int width;
        private final int length;

        HalfBlockFactory(int width, int length) {
            this.width = width;
            this.length = length;
        }

        @Override
        public Block create(Machine machine) {
            return new NormalBlock((2 + this.width) * 10 + this.length);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u6a5f\u4f53\u3092\u4f5c\u308b\u305f\u3081\u306e\u666e\u901a\u306e\u30d6\u30ed\u30c3\u30af";
        }
    }

    public static class HorizontalBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new HorizontalBlock(machine, null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u6a5f\u4f53\u306e\u50be\u304d\u3092\u8abf\u3079\u308b\n\u6c34\u5e73\u306a\u72b6\u614b\u304b\u3089\u306e\u305a\u308c\u304c\u5f97\u3089\u308c\u308b";
        }
    }

    public static class LightSensorBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new LightSensorBlock(machine, null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u7d2b\u306e\u9762\u306e\u5148\u306b\u3042\u308b\u3082\u306e\u306e\u660e\u308b\u3055\u3092\u8abf\u3079\u308b\n\u8272\u304c\u660e\u308b\u3044\u307b\u3069\u5927\u304d\u306a\u5024\u304c\u5f97\u3089\u308c\u308b";
        }
    }

    public static class LinkBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new LinkBlock(null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n2\u3064\u306e\u30d1\u30fc\u30c4\u3092\u63a5\u7d9a\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u308b\n\u56de\u8ee2\u306f\u81ea\u7531\u306a\u307e\u307e\u4f4d\u7f6e\u304c\u62d8\u675f\u3055\u308c\u308b";
        }
    }

    public static class MachineGunBlockFactory
    extends WeaponFactory {
        private final int length;

        MachineGunBlockFactory(int length) {
            this.length = length;
        }

        @Override
        public Block create(Machine machine) {
            return new MachineGunBlock(machine, null, this.length);
        }

        @Override
        protected String getDescription(WeaponBlock weapon, Bullet bullet, double reload) {
            return String.format("\u5a01\u529b: %.2f\n\u30ea\u30ed\u30fc\u30c9: %.2f\n\u5f3e\u901f: %.2f\n\u30de\u30ac\u30b8\u30f3: %d\n", bullet.getKineticEnergy() * 1.5, reload, bullet.getSpeed().getSize(), 30) + "\n\u9023\u5c04\u529b\u306e\u9ad8\u3044\u6b66\u5668";
        }
    }

    public static class MotorBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new MotorBlock(machine, null, null, new Part(machine));
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u9ec4\u8272\u306e\u9762\u306b\u3064\u3051\u305f\u30d1\u30fc\u30c4\u3092\u56de\u8ee2\u3055\u305b\u308b\u3053\u3068\u304c\u3067\u304d\u308b\n\u30d7\u30ed\u30b0\u30e9\u30e0\u304b\u3089\u96fb\u5727\u3092\u8a2d\u5b9a\u3059\u308b";
        }
    }

    public static class MouseAxisBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new MouseAxisBlock(machine, null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u30ab\u30e1\u30e9\u304c\u5411\u3044\u3066\u3044\u308b\u65b9\u5411\u3092\u8abf\u3079\u308b\n\u77e2\u5370\u306e\u65b9\u5411\u3068\u306e\u305a\u308c\u304c\u5f97\u3089\u308c\u308b";
        }
    }

    public static class NormalBlockFactory
    implements BlockFactory {
        private final int width;
        private final int length;

        NormalBlockFactory(int width, int length) {
            this.width = width;
            this.length = length;
        }

        @Override
        public Block create(Machine machine) {
            return new NormalBlock(this.width * 10 + this.length);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u6a5f\u4f53\u3092\u4f5c\u308b\u305f\u3081\u306e\u666e\u901a\u306e\u30d6\u30ed\u30c3\u30af";
        }
    }

    public static class RailBlockFactory
    extends WeaponFactory {
        private final int length;

        RailBlockFactory(int length) {
            this.length = length;
        }

        @Override
        public Block create(Machine machine) {
            return new RailBlock(machine, null, this.length);
        }

        @Override
        protected String getDescription(WeaponBlock weapon, Bullet bullet, double reload) {
            return String.format("\u5a01\u529b: %.2f\n\u30ea\u30ed\u30fc\u30c9: %.2f\n\u5f3e\u901f: %.2f\n", bullet.getKineticEnergy() * 1.5, reload, bullet.getSpeed().getSize()) + "\n\u5f3e\u901f\u306e\u901f\u3044\u6b66\u5668";
        }
    }

    public static class RifleBlockFactory
    extends WeaponFactory {
        private final int length;

        RifleBlockFactory(int length) {
            this.length = length;
        }

        @Override
        public Block create(Machine machine) {
            return new RifleBlock(machine, null, this.length);
        }

        @Override
        protected String getDescription(WeaponBlock weapon, Bullet bullet, double reload) {
            return String.format("\u5a01\u529b: %.2f\n\u30ea\u30ed\u30fc\u30c9: %.2f\n\u5f3e\u901f: %.2f\n", bullet.getKineticEnergy() * 1.5, reload, bullet.getSpeed().getSize()) + "\n\u6a19\u6e96\u7684\u306a\u6b66\u5668";
        }
    }

    public static class SpeedSensorBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new SpeedSensorBlock(null);
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u8ef8\u65b9\u5411\u3078\u306e\u30d6\u30ed\u30c3\u30af\u306e\u79fb\u52d5\u901f\u5ea6\u3092\u8abf\u3079\u308b";
        }
    }

    public static class SuperMotorBlockFactory
    implements BlockFactory {
        @Override
        public Block create(Machine machine) {
            return new SuperMotorBlock(machine, null, null, new Part(machine));
        }

        @Override
        public String getDescription() {
            return BlockFactory.super.getDescription() + "\n\u56de\u8ee2\u901f\u5ea6\u306e\u901f\u3044\u30e2\u30fc\u30bf\u30fc\n\u9ec4\u8272\u306e\u9762\u306b\u3064\u3051\u305f\u30d1\u30fc\u30c4\u3092\u56de\u8ee2\u3055\u305b\u308b\u3053\u3068\u304c\u3067\u304d\u308b\n\u30d7\u30ed\u30b0\u30e9\u30e0\u304b\u3089\u96fb\u5727\u3092\u8a2d\u5b9a\u3059\u308b";
        }
    }

    public static abstract class WeaponFactory
    implements BlockFactory {
        @Override
        public String getDescription() {
            WeaponBlock weapon = (WeaponBlock)this.create(null);
            double reload = 1.0 / weapon.getReloadSpeed();
            return BlockFactory.super.getDescription() + this.getDescription(weapon, weapon.getBullet(Vector.ZERO, new MutVector().set(weapon.getSpeed(), 0.0, 0.0)), reload);
        }

        protected abstract String getDescription(WeaponBlock var1, Bullet var2, double var3);
    }
}

