/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.client;

import java.util.LinkedList;
import java.util.Queue;
import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.sound.SoundSource;
import net.comp_lot.glui.system.Game;

class SoundPlayer {
    private final Queue<SoundEnum> soundQueue = new LinkedList<SoundEnum>();
    private SoundSource playingSource;

    SoundPlayer() {
    }

    public synchronized void play(SoundEnum sound, PlayMode mode) {
        switch (mode) {
            case WAIT: {
                this.soundQueue.add(sound);
                break;
            }
            case BREAK: {
                this.stopPlayingSound();
                this.soundQueue.clear();
                this.soundQueue.add(sound);
                break;
            }
            case DROP: {
                if (!this.soundQueue.isEmpty()) break;
                this.soundQueue.add(sound);
                break;
            }
        }
    }

    public synchronized void update(Game game) {
        if (this.playingSource != null && !this.playingSource.isPlaying()) {
            this.playingSource = null;
            this.soundQueue.poll();
        }
        if (this.playingSource == null && !this.soundQueue.isEmpty()) {
            this.playingSource = game.getAudioSystem().playSound(this.soundQueue.peek().getId(), ((CraftalosConfig)game.getConfig()).getVolumeVoice(), false);
        }
    }

    public synchronized void close() {
        this.stopPlayingSound();
        this.soundQueue.clear();
    }

    private void stopPlayingSound() {
        if (this.playingSource != null) {
            this.playingSource.stop();
            this.playingSource = null;
            this.soundQueue.poll();
        }
    }

    public static enum PlayMode {
        WAIT,
        BREAK,
        DROP;

    }
}

