/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.client;

import java.io.IOException;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.client.ClientMode;
import net.comp_lot.craftalos.system.network.Connection;
import net.comp_lot.craftalos.system.network.SocketConnection;
import net.comp_lot.craftalos.system.network.server.GameServerClient;
import net.comp_lot.craftalos.system.network.server.LobbyServer;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.glui.system.Game;

public class PlayMode
extends ClientMode {
    private final boolean enableLobby;
    private final boolean enableHost;
    private final RoomConfig roomConfig;
    private LobbyServer lobby;
    private GameServerClient host;

    protected PlayMode(Game game, String fileName, Main.Mode mode, boolean lobby, RoomConfig roomConfig, String address, int port, boolean ssl) {
        super(game, fileName, mode);
        this.enableLobby = lobby;
        this.enableHost = roomConfig != null;
        this.roomConfig = roomConfig;
        this.init(address, port, ssl);
    }

    public static PlayMode LocalPlay(Game game, String fileName, Main.Mode mode, RoomConfig roomConfig, int port) {
        return new PlayMode(game, fileName, mode, true, roomConfig, "localhost", port, false);
    }

    public static PlayMode HostPlay(Game game, String fileName, RoomConfig roomConfig, String address, int port, boolean ssl) {
        return new PlayMode(game, fileName, Main.Mode.HOST_PLAY, false, roomConfig, address, port, ssl);
    }

    public static PlayMode ClientPlay(Game game, String fileName, String address, int port, boolean ssl) {
        return new PlayMode(game, fileName, Main.Mode.JOIN, false, null, address, port, ssl);
    }

    public static PlayMode TestPlay(Game game, String fileName) {
        RoomConfig roomConfig = new RoomConfig();
        roomConfig.setMap("SimpleTestMap", "SimpleTestMap");
        roomConfig.setIsPublic("private");
        return PlayMode.LocalPlay(game, fileName, Main.Mode.TEST, roomConfig, 0);
    }

    @Override
    protected Connection connect(String address, int port, boolean ssl) {
        if (port < 0) {
            return this.localConnect();
        }
        if (this.enableLobby) {
            this.lobby = new LobbyServer(port, ssl, false);
            port = this.lobby.getPort();
        }
        if (this.enableHost) {
            this.host = new GameServerClient(this.roomConfig, address, port, ssl);
        }
        try {
            return SocketConnection.open(address, port, ssl);
        }
        catch (IOException e) {
            this.returnToTitle(StringManager.lang.clientFailedToConnect());
            return null;
        }
    }

    private Connection localConnect() {
        System.out.println("local connect");
        this.lobby = new LobbyServer();
        try {
            this.host = new GameServerClient(this.roomConfig, this.lobby.acceptLocal());
            return this.lobby.acceptLocal();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected RoomConfig getRoomConfig() {
        return this.roomConfig;
    }

    @Override
    public void onClose() {
        super.onClose();
        if (this.lobby != null) {
            this.lobby.close();
        }
        if (this.host != null) {
            this.host.close();
        }
    }
}

