/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.client;

import java.util.HashMap;
import java.util.Map;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.MultiLineComponent;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.layout.AbsoluteLayout;

class MiniMap {
    private static final int SIZE = 250;
    private static final double SCALE = 2000.0;
    private final DisplayInfo display;
    private final AbsoluteLayout layout;
    private final Map<Model, Component> models = new HashMap<Model, Component>();
    private Vector pos = Vector.ZERO;
    private Vector x = Vector.X_AXIS;
    private MutVector z = new MutVector().set(Vector.Z_AXIS);

    public MiniMap(DisplayInfo display) {
        this.display = display;
        this.layout = new AbsoluteLayout(display);
        this.layout.setWidth((int)(250.0 * display.getScale()));
        this.layout.setHeight((int)(250.0 * display.getScale()));
    }

    public void addModel(Model model, int color, int size) {
        if (model == null) {
            return;
        }
        Background component = new Background(this.display, color);
        component.setWidth((int)((double)size * this.display.getScale()));
        component.setHeight((int)((double)size * this.display.getScale()));
        this.models.put(model, component);
        this.layout.add(component);
    }

    public void addArea(Model model, int color) {
        if (model == null) {
            return;
        }
        MultiLineComponent component = new MultiLineComponent(this.display, color);
        component.setWidth((int)(250.0 * this.display.getScale()));
        component.setHeight((int)(250.0 * this.display.getScale()));
        this.models.put(model, component);
        this.layout.add(component);
    }

    public void removeModel(Model model) {
        this.layout.remove(this.models.remove(model));
    }

    public void clearModel() {
        this.models.clear();
        this.layout.clear();
    }

    public void setCenter(Vector pos, Vector axis) {
        this.pos = pos;
        this.z.set(axis).toOrthogonal(Vector.Y_AXIS).resize(1.0);
        this.x = MutVector.Cross(this.z, Vector.Y_AXIS).resize(1.0);
    }

    public void update() {
        this.models.entrySet().stream().forEach(e -> {
            Model m = (Model)e.getKey();
            Component c = (Component)e.getValue();
            if (c instanceof MultiLineComponent) {
                this.updateArea(m, (MultiLineComponent)c);
            } else {
                MutVector modelPos = new MutVector().set(this.pos, m.getBound().getCenter());
                this.layout.setPlace(c, this.worldToMapX(modelPos) - c.getRect().getWidth() / 2, this.worldToMapY(modelPos) - c.getRect().getHeight() / 2);
            }
        });
    }

    private void updateArea(Model m, MultiLineComponent c) {
        Bound b = m.getBound();
        MutVector va = new MutVector().set(b.getMinX(), 0.0, b.getMinZ()).add(this.pos, -1.0);
        MutVector vb = new MutVector().set(b.getMaxX(), 0.0, b.getMinZ()).add(this.pos, -1.0);
        MutVector vc = new MutVector().set(b.getMaxX(), 0.0, b.getMaxZ()).add(this.pos, -1.0);
        MutVector vd = new MutVector().set(b.getMinX(), 0.0, b.getMaxZ()).add(this.pos, -1.0);
        c.clear();
        c.addLine(this.worldToMapX(va), this.worldToMapY(va), this.worldToMapX(vb), this.worldToMapY(vb));
        c.addLine(this.worldToMapX(vb), this.worldToMapY(vb), this.worldToMapX(vc), this.worldToMapY(vc));
        c.addLine(this.worldToMapX(vc), this.worldToMapY(vc), this.worldToMapX(vd), this.worldToMapY(vd));
        c.addLine(this.worldToMapX(vd), this.worldToMapY(vd), this.worldToMapX(va), this.worldToMapY(va));
    }

    private int worldToMapX(Vector modelPos) {
        return (int)((double)(this.layout.getRect().getWidth() / 2) - Vector.Dot(this.x, modelPos) * (double)this.layout.getRect().getWidth() / 2000.0);
    }

    private int worldToMapY(Vector modelPos) {
        return (int)((double)(this.layout.getRect().getHeight() / 2) - Vector.Dot(this.z, modelPos) * (double)this.layout.getRect().getHeight() / 2000.0);
    }

    public Component getComponent() {
        return this.layout;
    }
}

