/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.client;

import net.comp_lot.craftalos.game.MachineState;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.client.ClientModeTextManager;
import net.comp_lot.craftalos.system.client.MiniMap;
import net.comp_lot.glui.system.utils.GluiXMLLayoutParser;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.Image;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.CenterLayout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

class ClientModeView {
    private final DisplayInfo uiDisplay;
    final Component loadingLayout;
    final Component rootLayout;
    final Layout center;
    private final Label debugLabel;
    private final Label enduranceLabel;
    private final Component energyBar;
    private final Component normalCenter;
    private final Component hitCenter;
    private final ClientModeTextManager textManager;
    private int oldEndurance = 0;
    private double enduranceRedTime = 0.0;

    public ClientModeView(DisplayInfo uiDisplay) {
        this.uiDisplay = uiDisplay;
        this.loadingLayout = new GluiXMLLayoutParser().parseOrElse(uiDisplay, this.getClass().getResourceAsStream("loading_layout.xml"), () -> null);
        ((Layout)this.loadingLayout.getComponentByName("loading-frame")).add(new LoadingLabel(uiDisplay));
        this.rootLayout = new GluiXMLLayoutParser().parseOrElse(uiDisplay, this.getClass().getResourceAsStream("client_mode_layout.xml"), () -> null);
        this.debugLabel = (Label)this.rootLayout.getComponentByName("debug-label");
        this.enduranceLabel = new Label(uiDisplay, 45);
        this.energyBar = new Background(uiDisplay, UIColor.WHITE, UIColor.NONE, 0);
        this.center = new CenterLayout(uiDisplay);
        this.normalCenter = new Image(uiDisplay, TextureEnum.UI_CLIENT_CENTER.getAsInfo());
        this.hitCenter = new Image(uiDisplay, TextureEnum.UI_CLIENT_CENTER_HIT.getAsInfo());
        this.textManager = new ClientModeTextManager(uiDisplay, (Layout)this.rootLayout.getComponentByName("big-label-layout"), (Layout)this.rootLayout.getComponentByName("mission-label-layout"), (Layout)this.rootLayout.getComponentByName("tips-label-layout"));
    }

    void initUI() {
        this.normalCenter.setWidth((int)(128.0 * this.uiDisplay.getScale()));
        this.normalCenter.setHeight((int)(128.0 * this.uiDisplay.getScale()));
        this.hitCenter.setWidth((int)(128.0 * this.uiDisplay.getScale()));
        this.hitCenter.setHeight((int)(128.0 * this.uiDisplay.getScale()));
        this.setOpLayout(true);
        VerticalLinearLayout stateLayout = (VerticalLinearLayout)this.rootLayout.getComponentByName("state-layout");
        stateLayout.setAlign(VerticalLinearLayout.LEFT);
        stateLayout.setMargin(30);
        stateLayout.add(this.energyBar);
        this.energyBar.setMinHeight(8);
        stateLayout.add(this.enduranceLabel);
        this.enduranceLabel.setMinWidth(90);
        this.enduranceLabel.setAlign(Label.Align.RIGHT);
    }

    void setOpLayout(boolean canRestart) {
        Layout opLayout = (Layout)this.rootLayout.getComponentByName("op-layout");
        opLayout.clear();
        Label label = new Label(this.uiDisplay, 30);
        label.setText(StringManager.lang.clientFlipKey("F"));
        opLayout.add(label);
        if (canRestart) {
            label = new Label(this.uiDisplay, 30);
            label.setText(StringManager.lang.clientRestartKey("Enter"));
            opLayout.add(label);
        }
        label = new Label(this.uiDisplay, 30);
        label.setText(StringManager.lang.clientActionKey("Z"));
        opLayout.add(label);
    }

    void setMiniMap(MiniMap miniMap) {
        Layout frame = (Layout)this.rootLayout.getComponentByName("map-frame");
        frame.remove(miniMap.getComponent());
        frame.add(miniMap.getComponent());
    }

    void setFps(double simFps, double comFps, double grpFps) {
        this.debugLabel.setText(String.format("Simulation fps : %.1f\nCommunication fps : %.1f\nGraphics fps : %.1f", simFps, comFps, grpFps));
    }

    void setMachineState(MachineState state) {
        this.setEndurance((int)Math.ceil(state.getEndurance()));
        this.setEnergy(state.getEnergy());
    }

    private void setEndurance(int endurance) {
        if (endurance < this.oldEndurance) {
            this.enduranceRedTime = 0.25;
        }
        this.oldEndurance = endurance;
        this.enduranceLabel.setText(String.format("%d", endurance));
        this.enduranceLabel.setColor(this.enduranceRedTime > 0.0 ? -1610612481 : -1);
        if (this.enduranceRedTime > 0.0) {
            this.enduranceRedTime -= 0.016666666666666666;
        }
    }

    private void setEnergy(double energy) {
        this.energyBar.setMinWidth((int)(energy * (double)this.enduranceLabel.getPreferredWidth()));
    }

    void setCenter(boolean hit) {
        this.center.clear();
        this.center.add(hit ? this.hitCenter : this.normalCenter);
    }

    ClientModeTextManager getTextManager() {
        return this.textManager;
    }

    private static class LoadingLabel
    extends Label {
        private static final int TIME = 60;
        private int time = 0;
        private int cnt = 0;

        protected LoadingLabel(DisplayInfo display) {
            super(display, 64, ".");
            this.setWidth(50);
        }

        @Override
        protected void draw(int x, int y, int width, int height) {
            super.draw(x, y, width, height);
            ++this.time;
            if (this.time >= 60) {
                this.time = 0;
                this.cnt = (this.cnt + 1) % 4;
                Object s = "";
                int i = 0;
                while (i < this.cnt) {
                    s = (String)s + ".";
                    ++i;
                }
                this.setText((String)s);
            }
        }
    }
}

