/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.client;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.game.GameCamera;
import net.comp_lot.craftalos.game.MachineModel;
import net.comp_lot.craftalos.game.MachineState;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.mission.Mission;
import net.comp_lot.craftalos.mission.MissionData;
import net.comp_lot.craftalos.mission.MissionResult;
import net.comp_lot.craftalos.program.compiler.Includer;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.craftalos.system.GamePlayMode;
import net.comp_lot.craftalos.system.client.BlockDestruction;
import net.comp_lot.craftalos.system.client.ClientModeTextManager;
import net.comp_lot.craftalos.system.client.ClientModeView;
import net.comp_lot.craftalos.system.client.MiniMap;
import net.comp_lot.craftalos.system.client.PlayMode;
import net.comp_lot.craftalos.system.client.SoundPlayer;
import net.comp_lot.craftalos.system.network.Connection;
import net.comp_lot.craftalos.system.network.data.WorldDataCache;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.craftalos.system.title.TitleMode;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.camera.Camera;
import net.comp_lot.glui.model.CoordinateSystem;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.FPSKeeper;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.ui.core.Component;

public abstract class ClientMode
extends GamePlayMode {
    private Connection socket;
    private final Main.Mode mode;
    private final String fileName;
    private final OperationEvent.KeyState keyState = new OperationEvent.KeyState();
    private final ClientModeView view;
    private final ClientModeTextManager textManager;
    private boolean modelReceived = false;
    private boolean initialized = false;
    private boolean running = false;
    private volatile byte lastReceived = 0;
    private boolean close = false;
    private WorldDataCache worldData;
    private ModelGroup model = null;
    private final ModelGroup entityModel = new ModelGroup();
    private Model map = new ModelGroup();
    private final GameCamera gameCamera = new GameCamera();
    private final Camera camera = new Camera();
    private final MutVector cameraPos = new MutVector().set(0.0, 0.0, -5.0);
    private float cameraTopOffset = 15.0f;
    private float cameraDistOffset = 45.0f;
    private final Map<Integer, Model> modelMap = new HashMap<Integer, Model>();
    private final List<Model> entityModels = new ArrayList<Model>();
    private final Map<Integer, Sound> sounds = new HashMap<Integer, Sound>();
    private final Map<Integer, Sound> soundsBuf = new HashMap<Integer, Sound>();
    private final List<BlockDestruction> destructions = new ArrayList<BlockDestruction>();
    private final MachineState machineState = new MachineState();
    private final Queue<String> textQueue = new LinkedList<String>();
    private int machineId = -1;
    private double hitTime = 0.0;
    private double fps = 0.0;
    private double receiveFps = 0.0;
    private final FPSKeeper receiveFpsManager = new FPSKeeper(-1);
    private final Set<String> miniMapQueries = new HashSet<String>();
    private final MiniMap miniMap;
    private final SoundPlayer voicePlayer = new SoundPlayer();
    private Object sendLock = new Object();

    public ClientMode(Game game, String fileName, Main.Mode mode) {
        super(game, -1, false, mode == Main.Mode.TEST, mode);
        this.camera.setSensitivity(((CraftalosConfig)game.getConfig()).getMouseSensitivity());
        this.mode = mode;
        this.fileName = fileName;
        this.view = new ClientModeView(this.uiDisplay);
        this.addUI(this.view.loadingLayout);
        this.textManager = this.view.getTextManager();
        this.miniMap = new MiniMap(this.uiDisplay);
    }

    protected final void init(String address, int port, boolean ssl) {
        new Thread(() -> this.initConnection(this.connect(address, port, ssl)), "CT Client Connect").start();
    }

    protected abstract Connection connect(String var1, int var2, boolean var3);

    protected abstract RoomConfig getRoomConfig();

    private final void initConnection(Connection socket) {
        this.socket = socket;
        try {
            socket.oos.writeUTF("guest \u03b21.5.0");
            socket.oos.writeUTF(Main.room);
            socket.oos.flush();
            String state = socket.ois.readUTF();
            if (!state.equals("OK")) {
                this.returnToTitle(state);
                return;
            }
            if (!this.sendMachine()) {
                return;
            }
        }
        catch (IOException e) {
            if (this.fileName == null) {
                this.returnToTitle(StringManager.lang.clientMachineNotSelected());
            } else {
                this.returnToTitle(StringManager.lang.clientFailedToJoin());
            }
            return;
        }
        new Thread(this::sendLoop, "CT Client Send").start();
        new Thread(this::receiveLoop, "CT Client Receive").start();
        this.running = true;
    }

    private void sendLoop() {
        while (!this.close) {
            try {
                this.send();
            }
            catch (IOException e) {
                break;
            }
        }
    }

    private void receiveLoop() {
        while (!this.close) {
            try {
                this.lastReceived = this.socket.ois.readByte();
                this.receive();
            }
            catch (IOException e) {
                break;
            }
        }
        if (!this.close) {
            if (Main.returnMessage == null) {
                this.returnToTitle(StringManager.lang.clientDisconnectedFromServer());
            } else {
                this.returnToTitle(null);
            }
        }
    }

    protected void returnToTitle(String message) {
        if (!this.close && message != null) {
            Main.returnMessage = message;
            System.err.println(Main.returnMessage);
        }
        this.setMode((Game game) -> new TitleMode((Game)game));
    }

    protected void initUI() {
        this.addUI(this.view.rootLayout);
        this.addRootUI(this.view.center);
        this.view.initUI();
    }

    @Override
    protected Component makeMenuItems() {
        if (this.mode == Main.Mode.HOST_PLAY) {
            MenuManager menu = new MenuManager(this.uiDisplay);
            menu.set(StringManager.lang.gameMenuPath() + "menu_private_host.md");
            menu.setListener("close", args -> {
                this.showMenu(null);
                menu.set(StringManager.lang.gameMenuPath() + "menu_private_host.md");
            });
            menu.setListener("quit", args -> {
                this.showMenu(null);
                this.returnToTitle(null);
            });
            menu.setListener("copy", args -> {
                Toolkit kit = Toolkit.getDefaultToolkit();
                Clipboard clip = kit.getSystemClipboard();
                StringSelection ss = new StringSelection(Main.room);
                clip.setContents(ss, ss);
            });
            menu.setGetter("$room", args -> Main.room);
            return menu.getComponent();
        }
        if (Main.missionID != null) {
            MenuManager menu = new MenuManager(this.uiDisplay);
            menu.set(StringManager.lang.gameMenuPath() + "menu_mission.md");
            menu.setListener("close", args -> this.showMenu(null));
            menu.setListener("restart", args -> this.setMode((Game game) -> PlayMode.LocalPlay(game, this.fileName, this.mode, this.getRoomConfig(), 0)));
            menu.setListener("quit", args -> this.returnToTitle(null));
            return menu.getComponent();
        }
        return super.makeMenuItems();
    }

    private boolean sendMachine() throws IOException {
        String[] source = this.loadMachine();
        this.socket.oos.writeUTF(source[0]);
        this.socket.oos.writeUTF(source[1]);
        this.socket.oos.flush();
        int i = 0;
        while (i < 3) {
            String r = this.socket.ois.readUTF();
            if (!r.endsWith("OK")) {
                this.returnToTitle(r);
                return false;
            }
            ++i;
        }
        this.machineId = this.socket.ois.readInt();
        this.worldData = new WorldDataCache(0, this.machineId);
        MutVector camera = new MutVector();
        camera.read(this.socket.ois);
        this.camera.setCameraAxis(camera);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send() throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            try {
                this.sendLock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.socket.oos.writeByte(this.lastReceived);
        object = this.keyState;
        synchronized (object) {
            this.keyState.write(this.socket.oos);
        }
        object = this.camera;
        synchronized (object) {
            this.camera.getCameraAxis().write(this.socket.oos);
        }
        this.socket.oos.flush();
        this.socket.oos.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive() throws IOException {
        boolean modelReceived = false;
        String type = "";
        while (!type.equals("end")) {
            type = this.socket.ois.readUTF();
            switch (type) {
                case "mdl": {
                    this.updateModelHost();
                    modelReceived = true;
                    break;
                }
                case "wrd": {
                    this.worldData.read(this.socket.ois);
                    break;
                }
                case "txt": {
                    this.readText();
                    break;
                }
                default: {
                    throw new IOException("Unknown data type : '" + type + "'");
                }
                case "end": 
            }
        }
        this.receiveFpsManager.keep();
        Object object = this.gameCamera;
        synchronized (object) {
            this.gameCamera.set(this.worldData.getCameras().get(0));
            this.worldData.getCSList().stream().filter(cs -> cs.isChanged()).forEach(cs -> {
                if (this.modelMap.containsKey(cs.getId())) {
                    this.modelMap.get(cs.getId()).setCoordinateSystem((CoordinateSystem)cs);
                }
                cs.setChangedToFalse();
            });
            this.entityModels.clear();
            this.soundsBuf.clear();
            this.worldData.getEntities().stream().forEach(e -> this.addEntity((Entity)e));
            this.machineState.copy(this.worldData.getMachineStates().get(0));
            this.fps = this.worldData.getServerFps();
            this.receiveFps = this.receiveFpsManager.getFps();
        }
        if (modelReceived) {
            this.modelReceived = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModelHost() throws IOException {
        try {
            ModelGroup model = (ModelGroup)this.socket.ois.readObject();
            model.resetBound();
            GameCamera gameCamera = this.gameCamera;
            synchronized (gameCamera) {
                this.model = model;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected void addEntity(Entity entity) {
        if (entity instanceof Sound) {
            this.soundsBuf.put(((Sound)entity).getId(), (Sound)entity);
            return;
        }
        if (entity.getModel() != null) {
            this.entityModels.add(entity.getModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readText() throws IOException {
        Queue<String> queue = this.textQueue;
        synchronized (queue) {
            this.textQueue.add(this.socket.ois.readUTF());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptText(String text) {
        if (text.startsWith("!")) {
            if (text.startsWith("!close")) {
                this.close(text);
            }
            if (text.startsWith("!restart:")) {
                boolean canRestart = Boolean.parseBoolean(text.substring(text.indexOf(":") + 1));
                this.view.setOpLayout(canRestart);
            }
            if (text.startsWith("!minimap")) {
                MiniMap canRestart = this.miniMap;
                synchronized (canRestart) {
                    if (text.equals("!minimap:true")) {
                        this.miniMapQueries.clear();
                    }
                    this.miniMapQueries.add(text);
                    this.setMiniMap(text);
                }
            }
            if (text.startsWith("!sound")) {
                this.playSound(text);
            }
            if (text.startsWith("!destruct")) {
                String[] t = text.split(" ");
                this.destructions.add(new BlockDestruction(Integer.parseInt(t[1]), Boolean.parseBoolean(t[2])));
            }
        } else if (text.startsWith("*")) {
            this.hitTime = 0.25;
        } else if (text.startsWith("#")) {
            this.textManager.setText(text);
        } else {
            System.out.println(text);
            this.showMessage(text);
        }
    }

    private void close(String text) {
        String state = text.replaceAll("!close\\((.*)\\)", "$1");
        if (state.startsWith("clear")) {
            MissionData.getMission(Main.missionID).ifPresent(m -> {
                if (state.matches("clear:(.+):(.+)")) {
                    double time = Double.parseDouble(state.replaceAll("clear:(.+):(.+)", "$1"));
                    String rank = state.replaceAll("clear:(.+):(.+)", "$2");
                    String reward = null;
                    if (!m.isClear() && m.getRewards().count() > 0L) {
                        StringBuilder sb = new StringBuilder(StringManager.lang.missionReward());
                        m.getRewards().forEach(r -> {
                            StringBuilder stringBuilder2 = sb.append(StringManager.lang.missionRewardMachine(r.substring(r.lastIndexOf("/") + 1)));
                        });
                        reward = sb.toString();
                    }
                    if (m.updateState(Mission.MissionState.valueOf("CLEAR_" + rank))) {
                        MissionData.save();
                    }
                    Main.missionResult = new MissionResult((Mission)m, time, rank, reward);
                }
            });
        } else if (state.equals("failure")) {
            this.close = true;
            DialogBuilder dialog = DialogBuilder.newYesNoDialog(this, StringManager.lang.clientRetryMessage(), StringManager.lang.clientRetry(), StringManager.lang.clientGiveUp(), () -> this.setMode((Game game) -> PlayMode.LocalPlay(game, this.fileName, this.mode, this.getRoomConfig(), 0)), () -> {
                boolean bl = this.running = false;
            });
            dialog.show(this);
            this.showPointer(true);
            return;
        }
        this.running = false;
    }

    private void playSound(String text) {
        String[] args = text.replaceAll("!sound\\((.*)\\)", "$1").replaceAll(" ", "").split(",");
        try {
            this.voicePlayer.play(SoundEnum.valueOf(args[0]), SoundPlayer.PlayMode.valueOf(args[1].toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    private void setMiniMap(String text) {
        String[] args;
        if (text.equals("!minimap:true")) {
            this.view.setMiniMap(this.miniMap);
            this.miniMap.clearModel();
            this.miniMap.addModel(this.modelMap.get(this.machineId), 0xFF00FF, 5);
            this.miniMap.addArea(this.map, -1);
        }
        if (text.matches("!minimap:add\\(([0-9]+) *, *([a-zA-Z_]+)\\)")) {
            this.miniMap.addModel(this.modelMap.get(Integer.parseInt(args[0])), (args = text.replaceAll("!minimap:add\\(([0-9]+) *, *([a-zA-Z_]+)\\)", "$1,$2").split(","))[1].equals("target") ? -16776961 : (args[1].equals("objective") ? 0xFFFFFF : -1), 3);
        }
        if (text.matches("!minimap:area\\(([0-9]+) *, *([a-zA-Z_]+)\\)")) {
            this.miniMap.addArea(this.modelMap.get(Integer.parseInt(args[0])), (args = text.replaceAll("!minimap:area\\(([0-9]+) *, *([a-zA-Z_]+)\\)", "$1,$2").split(","))[1].equals("objective") ? 0xFFFFFF : (args[1].equals("defence") ? 0xFF00FF : -1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText() {
        Queue<String> queue = this.textQueue;
        synchronized (queue) {
            while (!this.textQueue.isEmpty()) {
                this.acceptText(this.textQueue.poll());
            }
        }
        this.textManager.update();
    }

    @Override
    protected final void onFrame() {
        super.onFrame();
        if (this.initialized) {
            this.onGameFrame();
        } else if (this.running && this.modelReceived) {
            this.removeUI(this.view.loadingLayout);
            this.initUI();
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onGameFrame() {
        this.updateKeyState();
        if (!this.running) {
            this.returnToTitle(null);
            return;
        }
        this.updateText();
        this.voicePlayer.update(this.getGame());
        Object object = this.gameCamera;
        synchronized (object) {
            MiniMap miniMap;
            if (this.model != null) {
                miniMap = this.miniMap;
                synchronized (miniMap) {
                    this.reloadModel();
                }
            }
            this.updateView();
            this.updateCamera();
            this.updateEntity();
            this.updateDestruction();
            this.mainModel.callConfirmCoordinate();
            this.mainModel.setBound();
            miniMap = this.miniMap;
            synchronized (miniMap) {
                this.miniMap.setCenter(this.gameCamera.getCameraPos(), this.gameCamera.isFixed() ? this.gameCamera.getCameraAxis() : this.camera.getCameraAxis());
                this.miniMap.update();
            }
        }
        object = this.sendLock;
        synchronized (object) {
            this.sendLock.notify();
        }
    }

    private void updateDestruction() {
        for (BlockDestruction bd : this.destructions) {
            if (!this.modelMap.containsKey(bd.getId())) continue;
            this.modelMap.get(bd.getId()).setVisible(bd.isRepair());
        }
        this.destructions.clear();
    }

    private void updateEntity() {
        this.entityModel.clearChildren();
        this.entityModel.addModels(this.entityModels.toArray(new Model[0]));
        this.sounds.keySet().retainAll(this.soundsBuf.keySet());
        this.soundsBuf.forEach((i, s) -> {
            if (!this.sounds.containsKey(i)) {
                this.sounds.put((Integer)i, (Sound)s);
                s.play(this.getGame().getAudioSystem(), (CraftalosConfig)this.getGame().getConfig());
            }
        });
    }

    private void updateView() {
        this.view.setFps(this.fps, this.receiveFps, this.getFps());
        this.view.setMachineState(this.machineState);
        this.view.setCenter(this.hitTime > 0.0);
        if (this.hitTime > 0.0) {
            this.hitTime -= 0.016666666666666666;
        }
    }

    private void updateCamera() {
        if (this.gameCamera.isFixed()) {
            this.cameraPos.set(this.gameCamera.getCameraPos());
            this.setCamera(this.cameraPos, this.gameCamera.getCameraAxis(), this.gameCamera.getCameraUp());
            this.getGame().getAudioSystem().setListener(this.cameraPos, this.gameCamera.getCameraAxis(), this.gameCamera.getCameraUp(), Vector.ZERO);
        } else {
            MutVector side = MutVector.Cross(this.camera.getCameraAxis(), Vector.Y_AXIS);
            MutVector topOffset = MutVector.Cross(this.camera.getCameraAxis(), side).resize(-this.cameraTopOffset);
            Camera.getCameraOffset(topOffset, this.gameCamera.getCameraPos(), 0.25, this.map);
            this.cameraPos.set(this.gameCamera.getCameraPos()).add(topOffset);
            MutVector distOffset = new MutVector().set(this.camera.getCameraAxis()).resize(-this.cameraDistOffset);
            Camera.getCameraOffset(distOffset, this.cameraPos, 0.25, this.map);
            this.setCamera(this.cameraPos.add(distOffset), this.camera.getCameraAxis(), Vector.Y_AXIS);
            this.getGame().getAudioSystem().setListener(this.cameraPos, this.camera.getCameraAxis(), Vector.Y_AXIS, Vector.ZERO);
        }
    }

    private void reloadModel() {
        this.mainModel.clearChildren();
        this.mainModel.addModels(this.model);
        this.modelMap.clear();
        this.addToMap(this.model);
        this.modelMap.values().stream().forEach(m -> {
            if (m.getParentId() >= 0 && m != this.model) {
                m.setParent((ModelGroup)this.modelMap.get(m.getParentId()));
            }
        });
        this.mainModel.addModels(this.entityModel);
        this.map = ((ModelGroup)this.model.getAllChildren().get(0)).getAllChildren().stream().filter(m -> !(m instanceof MachineModel)).findAny().get();
        this.map.onConfirmCoordinate(true);
        this.map.fix();
        this.miniMap.clearModel();
        this.miniMapQueries.stream().forEach(this::setMiniMap);
        this.model = null;
    }

    protected void addToMap(Model m) {
        this.modelMap.put(m.id, m);
        if (m instanceof ModelGroup) {
            ((ModelGroup)m).getAllChildren().stream().forEach(c -> this.addToMap((Model)c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKeyState() {
        OperationEvent.KeyState keyState = this.keyState;
        synchronized (keyState) {
            OperationEvent.KeyCode[] keyCodeArray = OperationEvent.KeyCode.values();
            int n = keyCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OperationEvent.KeyCode code = keyCodeArray[n2];
                if (this.getKeyDown(code)) {
                    this.keyState.setKey(code, true);
                } else if (!this.getKeyState(code)) {
                    this.keyState.setKey(code, false);
                }
                ++n2;
            }
        }
    }

    protected final boolean isAlive() {
        return this.machineState.getEndurance() > 0.0;
    }

    protected final Vector getCameraPos() {
        return this.cameraPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMouseMove(float x, float y) {
        if (!this.isInMenu() && !this.close) {
            Camera camera = this.camera;
            synchronized (camera) {
                this.camera.onMouseMove(x, y);
            }
        }
    }

    @Override
    protected void onMouseScroll(double size) {
        if (!this.isInMenu()) {
            this.cameraTopOffset = (float)((double)this.cameraTopOffset + -size * 0.5);
            if (this.cameraTopOffset < 7.5f) {
                this.cameraTopOffset = 7.5f;
            }
            if (this.cameraTopOffset > 22.5f) {
                this.cameraTopOffset = 22.5f;
            }
            this.cameraDistOffset = (float)((double)this.cameraDistOffset + -size * 2.0);
            if (this.cameraDistOffset < 15.0f) {
                this.cameraDistOffset = 15.0f;
            }
            if (this.cameraDistOffset > 75.0f) {
                this.cameraDistOffset = 75.0f;
            }
        }
    }

    @Override
    protected void onClose() {
        this.close = true;
        if (this.socket != null) {
            this.socket.close();
        }
        this.voicePlayer.close();
    }

    protected String[] loadMachine() throws FileNotFoundException {
        String[] source = new String[2];
        source[0] = FileUtils.loadFile(this.fileName + ".bcm");
        try {
            source[1] = FileUtils.loadFile(this.fileName + ".bcp");
        }
        catch (FileNotFoundException e) {
            source[1] = "float main(){}";
        }
        source[1] = new Includer().include(source[1]);
        return source;
    }
}

