/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.map.MapBuilderFactory;
import net.comp_lot.craftalos.map.MapProgram;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.PhysicsParent;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.glui.model.CoordinateSystem;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;

public class World {
    public static final int FRAME_NUM = 5;
    public static final double DELTA_TIME = 0.0033333333333333335;
    private final MapBuilder mapBuilder;
    private final MapProgram mapProgram;
    private final WorldObject mapObject;
    private final ModelGroup model = new ModelGroup();
    private final List<CoordinateSystem> csList = new ArrayList<CoordinateSystem>();
    private final List<Machine> machineList = new ArrayList<Machine>();
    private final List<Machine> playerList = new ArrayList<Machine>();
    private final EntityParent entities = new EntityParent();
    private final PhysicsParent physics = new PhysicsParent(this.entities);
    private boolean modelChanged = true;
    private final Consumer<String> printer;
    private final boolean damageEnable;

    public World(Consumer<String> printer, String mapName, boolean damageEnable) {
        this.printer = printer;
        this.mapBuilder = MapBuilderFactory.create(mapName, this);
        this.damageEnable = damageEnable;
        this.mapObject = this.mapBuilder.make();
        this.model.addModels(this.mapObject.getModel());
        this.physics.addObject(this.mapObject);
        PhysicsObject[] physicsObjectArray = this.mapBuilder.makeObjects();
        int n = physicsObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            PhysicsObject o = physicsObjectArray[n2];
            if (o != null) {
                this.model.addModels(o.getModel());
                this.physics.addObject(o);
            }
            ++n2;
        }
        this.mapProgram = this.mapBuilder.getProgram();
        this.mapProgram.init();
        this.initCoordinateAndBound();
        this.getCSList().forEach(cs -> cs.setChangedToFalse());
    }

    public Model getModel() {
        return this.model;
    }

    public WorldObject getMapObject() {
        return this.mapObject;
    }

    public Collection<WorldObject> getObjects() {
        return this.physics.getObjects();
    }

    public void addObject(WorldObject o) {
        this.model.addModels(o.getModel());
        this.physics.addObject(o);
        this.csList.clear();
        this.modelChanged = true;
    }

    public void removeObject(PhysicsObject o) {
        this.model.removeModel(o.getModel());
        this.physics.removeObject(o);
        this.csList.clear();
        this.modelChanged = true;
    }

    public void addMachine(Machine machine) {
        this.addObject(machine.getMachinePart());
        this.machineList.add(machine);
        this.model.callConfirmCoordinate();
        this.model.setBound();
        machine.setWorld(this);
        machine.setGlobalPrinter(this.printer);
        machine.initialize();
    }

    public void removeMachine(Machine machine) {
        this.machineList.remove(machine);
        this.removeObject(machine.getMachinePart());
    }

    public void addPlayerMachine(Machine machine) {
        this.addMachine(machine);
        this.playerList.add(machine);
        machine.setRestartPlace(this.mapBuilder.getFirstPlace(), this.mapBuilder.getFirstRotate());
        machine.setRestartPlaces(this.mapBuilder.getRestartPlaces(), this.mapBuilder.getRestartRotates());
        machine.restart();
    }

    public void removePlayerMachine(Machine machine) {
        this.playerList.remove(machine);
        this.removeMachine(machine);
    }

    public void enablePhysics(PhysicsObject o) {
        this.physics.addObject(o);
    }

    public void disablePhysics(PhysicsObject o) {
        this.physics.removeObject(o);
    }

    public List<Entity> getEntityList() {
        return this.entities.getEntities();
    }

    public void addEntity(Entity e) {
        this.entities.add(e);
    }

    public void initCoordinateAndBound() {
        this.model.callConfirmCoordinate();
        this.model.setBound();
    }

    public void frame() {
        int i = 0;
        while (i < 5) {
            this.entities.update(this.model);
            this.physics.compute();
            this.model.callConfirmCoordinate();
            this.model.setBound();
            this.machineList.parallelStream().forEach(m -> m.frame());
            ++i;
        }
        this.runMapProgram();
    }

    public void runMapProgram() {
        this.mapProgram.accept(this.playerList, this.printer);
    }

    public boolean isDamageEnable() {
        return this.damageEnable;
    }

    public List<CoordinateSystem> getCSList() {
        if (this.csList.isEmpty()) {
            this.addToCSList(this.getModel());
        }
        return this.csList;
    }

    private void addToCSList(Model m) {
        this.csList.add(m.getCoordinateSystem());
        if (m instanceof ModelGroup) {
            ((ModelGroup)m).getAllChildren().stream().forEach(c -> this.addToCSList((Model)c));
        }
    }

    public boolean isModelChanged() {
        return this.modelChanged;
    }

    public void resetModelChanged() {
        this.modelChanged = false;
    }
}

