/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system;

import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.client.PlayMode;
import net.comp_lot.craftalos.system.edit.EditMode;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.title.TitleMode;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.MessageBoard;
import net.comp_lot.glui.ui.NineSliceImage;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.AlignmentLayout;
import net.comp_lot.ui.layout.CenterLayout;
import net.comp_lot.ui.layout.FrameLayout;
import net.comp_lot.ui.layout.HorizontalLinearLayout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

public abstract class GamePlayMode
extends GameMode {
    private final Layout menuLayout;
    private final MessageBoard messageBoard;
    private final boolean pointer;
    private final Layout mainLayout;

    protected GamePlayMode(Game game, int targetFps, boolean pointer, boolean showTab, Main.Mode mode) {
        super(game, targetFps);
        this.menuLayout = new CenterLayout(this.uiDisplay);
        this.messageBoard = new MessageBoard(this.uiDisplay, 24, 10);
        this.mainLayout = new FrameLayout(this.uiDisplay);
        this.pointer = pointer;
        this.showPointer(pointer);
        this.menuLayout.setBackground(new Background((DisplayInfo)this.uiDisplay, UIColor.TRANSPARENT_BLACK, UIColor.NONE, 0));
        AlignmentLayout layout = new AlignmentLayout(this.uiDisplay);
        this.messageBoard.getComponent().setMargin(30);
        layout.add(this.messageBoard.getComponent());
        layout.setHorizontalAlign(this.messageBoard.getComponent(), AlignmentLayout.HORIZONTAL_LEFT);
        layout.setVerticalAlign(this.messageBoard.getComponent(), AlignmentLayout.VERTICAL_BOTTOM);
        this.addUI(layout);
        if (showTab) {
            this.makeTabUI(mode);
        } else {
            super.addUI(this.mainLayout);
        }
    }

    protected Component makeMenuItems() {
        MenuManager menu = new MenuManager(this.uiDisplay);
        menu.set(StringManager.lang.gameMenuPath() + "menu.md");
        menu.setListener("close", args -> this.showMenu(false));
        menu.setListener("quit", args -> this.setMode(Main.Mode.TITLE));
        return menu.getComponent();
    }

    private void makeTabUI(Main.Mode mode) {
        VerticalLinearLayout rootLayout = new VerticalLinearLayout(this.uiDisplay, 0);
        super.addUI(rootLayout);
        HorizontalLinearLayout layout = new HorizontalLinearLayout(this.uiDisplay, 7);
        layout.setPadding(3);
        layout.setPaddingBottom(0);
        layout.setBackground(new Background((DisplayInfo)this.uiDisplay, UIColor.ASH, UIColor.NONE, 0));
        this.addTabButton(layout, StringManager.lang.modeEdit(), mode != Main.Mode.EDIT, Main.Mode.EDIT);
        this.addTabButton(layout, StringManager.lang.modeProgram(), mode != Main.Mode.PROGRAM, Main.Mode.PROGRAM);
        this.addTabButton(layout, StringManager.lang.modeTest(), mode != Main.Mode.TEST, Main.Mode.TEST);
        rootLayout.add(layout);
        rootLayout.add(this.mainLayout);
        this.mainLayout.setMinWidth(Integer.MAX_VALUE);
        this.mainLayout.setMinHeight(Integer.MAX_VALUE);
    }

    private void addTabButton(Layout layout, String text, boolean enable, Main.Mode mode) {
        Label label = new Label(this.uiDisplay, 30, text);
        label.setAlign(Label.Align.CENTER);
        label.setWidth(128);
        ButtonLayout button = new ButtonLayout(this.uiDisplay, TextureEnum.UI_TAB_BUTTON_H.getAsInfo(), 24);
        button.setDisableColor(0x333388FF);
        button.setPaddingTop(6);
        button.add(label);
        button.setClickListener(() -> this.setMode(mode));
        button.setEnable(enable);
        layout.add(button);
    }

    protected void setMode(Main.Mode mode) {
        switch (mode) {
            case TEST: {
                this.setMode((Game game) -> PlayMode.TestPlay(game, ((CraftalosConfig)this.getGame().getConfig()).getFileName()));
                break;
            }
            case EDIT: {
                this.setMode((Game game) -> new EditMode((Game)game, ((CraftalosConfig)this.getGame().getConfig()).getFileName()));
                break;
            }
            case PROGRAM: {
                this.setMode((Game game) -> new ProgramMode((Game)game, ((CraftalosConfig)this.getGame().getConfig()).getFileName()));
                break;
            }
            case TITLE: {
                this.setMode((Game game) -> new TitleMode((Game)game));
                break;
            }
            default: {
                throw new RuntimeException("[Error] Mode : " + String.valueOf((Object)mode));
            }
        }
    }

    protected void addRootUI(Component c) {
        super.addUI(0, c);
    }

    @Override
    protected void addUI(Component c) {
        this.mainLayout.add(c);
    }

    @Override
    protected void addUI(int i, Component c) {
        this.mainLayout.add(i, c);
    }

    @Override
    protected void removeUI(Component c) {
        this.mainLayout.remove(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onFrame() {
        if (this.getKeyDownIgnoreMenu(OperationEvent.KeyCode.KEY_ESCAPE)) {
            this.showMenu(!this.isInMenu());
        }
        UIDisplay uIDisplay = this.uiDisplay;
        synchronized (uIDisplay) {
            this.messageBoard.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showMessage(String text) {
        UIDisplay uIDisplay = this.uiDisplay;
        synchronized (uIDisplay) {
            this.messageBoard.add(text);
        }
    }

    void showMenu(boolean show) {
        this.showMenu(show ? this.makeMenuItems() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMenu(Component menu) {
        this.setInMenu(menu != null);
        this.showPointer(this.pointer || menu != null);
        UIDisplay uIDisplay = this.uiDisplay;
        synchronized (uIDisplay) {
            if (this.isInMenu()) {
                this.removeUI(this.menuLayout);
            }
            if (menu != null) {
                this.menuLayout.clear();
                FrameLayout frame = new FrameLayout(this.uiDisplay, menu);
                frame.setPadding(24);
                frame.setPaddingBottom(48);
                frame.setBackground(new NineSliceImage(this.uiDisplay, TextureEnum.UI_WINDOW.getAsInfo(), 24, -1431633921));
                this.menuLayout.add(frame);
                this.addUI(this.menuLayout);
            }
        }
    }
}

