/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system;

import java.io.FileNotFoundException;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.game.MachineChecker;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.craftalos.system.GamePlayMode;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.system.utils.MenuManager;

public abstract class EditableMode
extends GamePlayMode {
    private final String fileName;

    protected EditableMode(Game game, boolean pointer, Main.Mode mode, String fileName) {
        super(game, 60, pointer, true, mode);
        this.fileName = fileName;
    }

    protected abstract boolean isUpdated();

    protected abstract boolean save();

    public boolean callSave() {
        if (this.getFileName().startsWith("res/")) {
            MenuManager menu = new MenuManager(this.uiDisplay);
            menu.setGetter("$message", args -> StringManager.lang.sampleOverwrite());
            menu.set(StringManager.lang.gameMenuPath() + "save_failed.md");
            menu.setListener("ok", args -> this.showMenu(null));
            this.showMenu(menu.getComponent());
            return false;
        }
        return this.save();
    }

    protected String getFileName() {
        return this.fileName;
    }

    @Override
    protected void setMode(Main.Mode mode) {
        if (this.isUpdated()) {
            MenuManager menu = new MenuManager(this.uiDisplay);
            menu.set(StringManager.lang.gameMenuPath() + "save.md");
            menu.setListener("save", args -> {
                if (this.callSave()) {
                    this.setMode(mode);
                }
            });
            menu.setListener("quit", args -> super.setMode(mode));
            menu.setListener("cancel", args -> this.showMenu(null));
            this.showMenu(menu.getComponent());
        } else {
            if (mode == Main.Mode.TEST) {
                try {
                    MachineChecker checker = new MachineChecker(MachineCompiler.compile(FileUtils.loadFile(this.fileName + ".bcm")));
                    if (!checker.check()) {
                        MenuManager menu = new MenuManager(this.uiDisplay);
                        menu.setGetter("$message", args -> StringManager.lang.editMachineProblem(checker.getMessage()));
                        menu.set(StringManager.lang.gameMenuPath() + "error.md");
                        menu.setListener("ok", args -> this.showMenu(null));
                        this.showMenu(menu.getComponent());
                        return;
                    }
                }
                catch (FileNotFoundException | CompileException e) {
                    e.printStackTrace();
                    this.showMessage(e.getLocalizedMessage());
                    return;
                }
            }
            super.setMode(mode);
        }
    }
}

