/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system;

import java.util.ArrayList;
import java.util.List;

public class EditHistory<T> {
    private final List<T> hist = new ArrayList<T>();
    private int index = -1;
    private int savedIndex = 0;

    public EditHistory(T initialState) {
        this.addHistory(initialState);
    }

    public void addHistory(T state) {
        if (this.index + 1 < this.hist.size()) {
            int i = this.hist.size() - 1;
            while (i > this.index) {
                this.hist.remove(i);
                if (i == this.savedIndex) {
                    this.savedIndex = -1;
                }
                --i;
            }
        }
        this.hist.add(state);
        ++this.index;
    }

    public T undo() {
        if (this.index > 0) {
            return this.hist.get(--this.index);
        }
        return null;
    }

    public T redo() {
        if (this.index + 1 < this.hist.size()) {
            return this.hist.get(++this.index);
        }
        return null;
    }

    public T getState() {
        if (this.index >= 0) {
            return this.hist.get(this.index);
        }
        return null;
    }

    public void markSaved() {
        this.savedIndex = this.index;
    }

    public boolean isUpdated() {
        return this.index != this.savedIndex;
    }
}

