/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.BlockCloseBlock;
import net.comp_lot.craftalos.system.program.block.WhileBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class WhileNode
extends ProgramNode {
    private ProgramNode cond;
    private ProgramNode child;

    public WhileNode(ProgramNode parent, int srcAt) {
        super(parent, srcAt);
    }

    public void setCond(ProgramNode node) {
        this.cond = node;
    }

    public void setChild(ProgramNode node) {
        this.child = node;
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        while (this.cond.execute().getValue() != 0.0) {
            ProgramNode.Result r = this.child.execute();
            if (!r.isReturn()) continue;
            return r;
        }
        return ProgramNode.Result.getNormalResult(0.0);
    }

    @Override
    public ProgramNode clone(ProgramNode parent) {
        return new WhileNode(parent, this.getSrcAt()).copy(this);
    }

    @Override
    protected WhileNode copy(ProgramNode original) {
        super.copy(original);
        WhileNode node = (WhileNode)original;
        this.cond = node.cond.clone(this);
        this.child = node.child.clone(this);
        return this;
    }

    @Override
    public List<ProgramBlock> convertToBlocks(DisplayInfo display, ProgramMode editer) {
        ArrayList<ProgramBlock> list = new ArrayList<ProgramBlock>();
        WhileBlock whileBlock = new WhileBlock(display);
        BlockCloseBlock endWhileBlock = new BlockCloseBlock(display);
        whileBlock.setValue(0, this.cond.convertToBlock(display, editer));
        list.add(whileBlock);
        this.child.convertToBlocks(display, editer).stream().forEach(list::add);
        list.add(endWhileBlock);
        ProgramBlock.setLink(whileBlock, endWhileBlock);
        return list;
    }
}

