/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import net.comp_lot.craftalos.program.IdentNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.VarDecBlock;
import net.comp_lot.craftalos.system.program.block.VarDecSetBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class VarDecNode
extends IdentNode {
    private ProgramNode init;
    private double value;

    public VarDecNode(ProgramNode parent, int srcAt, String ident) {
        super(parent, srcAt, ident);
    }

    public void setInit(ProgramNode init) {
        this.init = init;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        this.value = this.init != null ? this.init.execute().getValue() : 0.0;
        return ProgramNode.Result.getNormalResult(this.value);
    }

    @Override
    public VarDecNode clone(ProgramNode parent) {
        return new VarDecNode(parent, this.getSrcAt(), this.getIdent()).copy(this);
    }

    @Override
    protected VarDecNode copy(ProgramNode original) {
        super.copy(original);
        VarDecNode node = (VarDecNode)original;
        if (node.init != null) {
            this.init = node.init.clone(this);
        }
        this.value = node.value;
        return this;
    }

    @Override
    public ProgramBlock convertToBlock(DisplayInfo display, ProgramMode editer) {
        if (this.init == null) {
            VarDecBlock rtn = new VarDecBlock(display);
            rtn.setValue(0, this.getIdent());
            return rtn;
        }
        VarDecSetBlock rtn = new VarDecSetBlock(display);
        rtn.setValue(0, this.getIdent());
        rtn.setValue(1, this.init.convertToBlock(display, editer));
        return rtn;
    }
}

