/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.IdentNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.program.node.AryDecNode;
import net.comp_lot.craftalos.program.node.FunDecNode;
import net.comp_lot.craftalos.program.node.VarDecNode;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.ui.core.DisplayInfo;

public class TopNode
extends ProgramNode {
    private List<ProgramNode> children = new ArrayList<ProgramNode>();
    private Map<String, FunDecNode> functions = new HashMap<String, FunDecNode>();
    private Map<String, VarDecNode> variables = new HashMap<String, VarDecNode>();
    private Map<String, AryDecNode> arrays = new HashMap<String, AryDecNode>();

    public TopNode() {
        super(null, -1);
        this.variables.put("#node execute", new VarDecNode(this, -1, "#node execute"));
    }

    public void addChildToTop(ProgramNode child) {
        this.children.add(0, child);
        this.addChildToMap(child);
    }

    public void addChild(ProgramNode child) {
        this.children.add(child);
        this.addChildToMap(child);
    }

    private void addChildToMap(ProgramNode child) {
        if (child instanceof FunDecNode) {
            FunDecNode node = (FunDecNode)child;
            this.functions.put(String.format("%s(%d)", node.getIdent(), node.getArgumentsNum()), node);
        }
    }

    public Collection<FunDecNode> getFunctions() {
        return this.functions.values();
    }

    public Stream<VarDecNode> getVariables() {
        return this.children.stream().filter(n -> n instanceof VarDecNode).map(n -> (VarDecNode)n);
    }

    public Stream<AryDecNode> getArrays() {
        return this.children.stream().filter(n -> n instanceof AryDecNode).map(n -> (AryDecNode)n);
    }

    public void runInit() throws MachineProgram.ProgramException {
        this.getVariable("#node execute", -1).setValue(100000.0);
        for (ProgramNode n : this.children) {
            IdentNode node;
            if (n instanceof VarDecNode) {
                node = (VarDecNode)n;
                node.execute();
                this.variables.put(node.getIdent(), (VarDecNode)node);
            }
            if (!(n instanceof AryDecNode)) continue;
            node = (AryDecNode)n;
            node.execute();
            this.arrays.put(node.getIdent(), (AryDecNode)node);
        }
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        return this.getFunction("main(0)", -1).execute();
    }

    public void launch() throws MachineProgram.ProgramException {
        this.run();
    }

    @Override
    public ProgramNode clone(ProgramNode parent) {
        return new TopNode().copy(this);
    }

    @Override
    protected TopNode copy(ProgramNode original) {
        super.copy(original);
        TopNode node = (TopNode)original;
        node.children.stream().forEach(n -> this.addChild(n.clone(this)));
        return this;
    }

    @Override
    public VarDecNode getVariable(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (this.variables.containsKey(ident)) {
            return this.variables.get(ident);
        }
        throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorVariableNotFound(ident), srcAt);
    }

    @Override
    protected AryDecNode getArray(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (this.arrays.containsKey(ident)) {
            return this.arrays.get(ident);
        }
        throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorArrayNotFound(ident), srcAt);
    }

    @Override
    public FunDecNode getFunction(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (srcAt < 0) {
            this.getVariable("#node execute", -1).setValue(100000.0);
        }
        if (this.functions.containsKey(ident)) {
            return this.functions.get(ident).clone(this);
        }
        throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorFunctionNotFound(ident), srcAt);
    }

    @Override
    public List<ProgramBlock> convertToBlocks(DisplayInfo display, ProgramMode editer) {
        ArrayList<ProgramBlock> list = new ArrayList<ProgramBlock>();
        this.children.stream().flatMap(n -> n.convertToBlocks(display, editer).stream()).forEach(list::add);
        return list;
    }
}

