/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.ui.core.DisplayInfo;

public class StringNode
extends ProgramNode {
    private final int num;
    private static final List<String> STRINGS = new ArrayList<String>();

    public StringNode(ProgramNode parent, int srcAt, String value) {
        super(parent, srcAt);
        this.num = STRINGS.size();
        STRINGS.add(value);
    }

    private StringNode(ProgramNode parent, int srcAt, int num) {
        super(parent, srcAt);
        this.num = num;
    }

    @Override
    public ProgramBlock convertToBlock(DisplayInfo display, ProgramMode editer) {
        return null;
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        return ProgramNode.Result.getNormalResult(this.num);
    }

    @Override
    public ProgramNode clone(ProgramNode parent) {
        return new StringNode(parent, this.getSrcAt(), this.num).copy(this);
    }

    public static String get(int num) throws MachineProgram.ProgramException {
        if (num < 0 || num >= STRINGS.size()) {
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorUnknownString(num), -1);
        }
        return STRINGS.get(num);
    }
}

