/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.BinaryNode;
import net.comp_lot.craftalos.program.IdentNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.program.node.AryNode;
import net.comp_lot.craftalos.program.node.VarNode;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.ArySetBlock;
import net.comp_lot.craftalos.system.program.block.VarSetBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class SetNode
extends BinaryNode {
    public SetNode(ProgramNode parent, int srcAt) {
        super(parent, srcAt);
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        if (this.getLeft() instanceof VarNode) {
            ProgramNode.Result result = this.runRight();
            ((VarNode)this.getLeft()).setValue(result.getValue());
            return result;
        }
        if (this.getLeft() instanceof AryNode) {
            ProgramNode.Result result = this.runRight();
            ((AryNode)this.getLeft()).setValue(result.getValue());
            return result;
        }
        throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorCannotAssign(), this.getSrcAt());
    }

    @Override
    public ProgramNode clone(ProgramNode parent) {
        return new SetNode(parent, this.getSrcAt()).copy(this);
    }

    @Override
    public ProgramBlock convertToBlock(DisplayInfo display, ProgramMode editor) {
        if (this.getLeft() instanceof VarNode) {
            VarSetBlock rtn = new VarSetBlock(display, editor);
            rtn.setValue(0, ((IdentNode)this.getLeft()).getIdent());
            rtn.setValue(1, this.getRight().convertToBlock(display, editor));
            return rtn;
        }
        ArySetBlock rtn = new ArySetBlock(display, editor);
        rtn.setValue(0, ((IdentNode)this.getLeft()).getIdent());
        rtn.setValue(1, ((AryNode)this.getLeft()).getChild().convertToBlock(display, editor));
        rtn.setValue(2, this.getRight().convertToBlock(display, editor));
        return rtn;
    }
}

