/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.NumBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class NumNode
extends ProgramNode {
    private final String valueStr;
    private final double value;

    public NumNode(ProgramNode parent, int srcAt, String valueStr) {
        super(parent, srcAt);
        this.valueStr = valueStr;
        this.value = valueStr.length() == 0 ? 0.0 : Double.parseDouble(valueStr);
    }

    public String getValueString() {
        return this.valueStr;
    }

    @Override
    protected ProgramNode.Result run() {
        return ProgramNode.Result.getNormalResult(this.value);
    }

    @Override
    public ProgramNode clone(ProgramNode parent) {
        return new NumNode(parent, this.getSrcAt(), this.valueStr).copy(this);
    }

    @Override
    public ProgramBlock convertToBlock(DisplayInfo display, ProgramMode editer) {
        NumBlock rtn = new NumBlock(display);
        rtn.setValue(0, String.valueOf(this.valueStr));
        return rtn;
    }
}

