/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.BlockCloseBlock;
import net.comp_lot.craftalos.system.program.block.ElseBlock;
import net.comp_lot.craftalos.system.program.block.IfBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class IfNode
extends ProgramNode {
    private ProgramNode cond;
    private ProgramNode ifBlock;
    private ProgramNode elseBlock;

    public IfNode(ProgramNode parent, int srcAt) {
        super(parent, srcAt);
    }

    public void setCond(ProgramNode node) {
        this.cond = node;
    }

    public void setIf(ProgramNode node) {
        this.ifBlock = node;
    }

    public void setElse(ProgramNode node) {
        this.elseBlock = node;
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        if (this.cond.execute().getValue() != 0.0) {
            return this.ifBlock.execute();
        }
        if (this.elseBlock != null) {
            return this.elseBlock.execute();
        }
        return ProgramNode.Result.getNormalResult(0.0);
    }

    @Override
    public ProgramNode clone(ProgramNode parent) {
        return new IfNode(parent, this.getSrcAt()).copy(this);
    }

    @Override
    protected IfNode copy(ProgramNode original) {
        super.copy(original);
        IfNode node = (IfNode)original;
        this.cond = node.cond.clone(this);
        this.ifBlock = node.ifBlock.clone(this);
        if (node.elseBlock != null) {
            this.elseBlock = node.elseBlock.clone(this);
        }
        return this;
    }

    @Override
    public List<ProgramBlock> convertToBlocks(DisplayInfo display, ProgramMode editer) {
        ArrayList<ProgramBlock> list = new ArrayList<ProgramBlock>();
        IfBlock ifBlock = new IfBlock(display);
        ifBlock.setValue(0, this.cond.convertToBlock(display, editer));
        list.add(ifBlock);
        this.ifBlock.convertToBlocks(display, editer).stream().forEach(list::add);
        BlockCloseBlock endIfBlock = new BlockCloseBlock(display);
        if (this.elseBlock != null) {
            ElseBlock elseBlock = new ElseBlock(display);
            list.add(elseBlock);
            this.elseBlock.convertToBlocks(display, editer).stream().forEach(list::add);
            ProgramBlock.setLink(ifBlock, elseBlock, endIfBlock);
        } else {
            ProgramBlock.setLink(ifBlock, endIfBlock);
        }
        list.add(endIfBlock);
        return list;
    }
}

