/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.IdentNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.program.node.FunDecNode;
import net.comp_lot.craftalos.program.node.VarNode;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.FAxisBlock;
import net.comp_lot.craftalos.system.program.block.FGetBlock;
import net.comp_lot.craftalos.system.program.block.FKeyBlock;
import net.comp_lot.craftalos.system.program.block.FKeyDownBlock;
import net.comp_lot.craftalos.system.program.block.FSetBlock;
import net.comp_lot.craftalos.system.program.block.FunBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class FunNode
extends IdentNode {
    private List<ProgramNode> children = new ArrayList<ProgramNode>();

    public FunNode(ProgramNode parent, int srcAt, String ident) {
        super(parent, srcAt, ident);
    }

    public void addChild(ProgramNode child) {
        this.children.add(child);
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        FunDecNode fun = this.getFunction(String.format("%s(%d)", this.getIdent(), this.children.size()), this.getSrcAt());
        if (fun.getArgumentsNum() != this.children.size()) {
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorFunctionArgumentNum(fun.getIdent(), fun.getArgumentsNum()), this.getSrcAt());
        }
        int i = 0;
        while (i < fun.getArgumentsNum()) {
            fun.setArgument(i, this.children.get(i).execute().getValue());
            ++i;
        }
        return ProgramNode.Result.getNormalResult(fun.execute().getValue());
    }

    @Override
    public FunNode clone(ProgramNode parent) {
        return new FunNode(parent, this.getSrcAt(), this.getIdent()).copy(this);
    }

    @Override
    protected FunNode copy(ProgramNode original) {
        super.copy(original);
        FunNode node = (FunNode)original;
        node.children.stream().forEach(n -> this.addChild(n.clone(this)));
        return this;
    }

    @Override
    public ProgramBlock convertToBlock(DisplayInfo display, ProgramMode editor) {
        ProgramBlock rtn;
        if (this.getIdent().equals("set") && this.children.get(0) instanceof VarNode) {
            rtn = new FSetBlock(display, editor);
            rtn.setValue(0, ((IdentNode)this.children.get(0)).getIdent());
            rtn.setValue(1, this.children.get(1).convertToBlock(display, editor));
        } else if (this.getIdent().equals("get") && this.children.get(0) instanceof VarNode) {
            rtn = new FGetBlock(display, editor);
            rtn.setValue(0, ((IdentNode)this.children.get(0)).getIdent());
        } else if (this.getIdent().equals("key") && this.children.get(0) instanceof VarNode) {
            rtn = new FKeyBlock(display, editor);
            rtn.setValue(0, ((IdentNode)this.children.get(0)).getIdent());
        } else if (this.getIdent().equals("keyDown") && this.children.get(0) instanceof VarNode) {
            rtn = new FKeyDownBlock(display, editor);
            rtn.setValue(0, ((IdentNode)this.children.get(0)).getIdent());
        } else if (this.getIdent().equals("axis") && this.children.get(0) instanceof VarNode) {
            rtn = new FAxisBlock(display, editor);
            rtn.setValue(0, ((IdentNode)this.children.get(0)).getIdent());
        } else {
            rtn = new FunBlock(display, editor);
            rtn.setValue(0, this.getIdent());
            ((FunBlock)rtn).setArgsNum(this.children.size());
            int i = 0;
            while (i < this.children.size()) {
                rtn.setValue(1 + i, this.children.get(i).convertToBlock(display, editor));
                ++i;
            }
        }
        return rtn;
    }
}

