/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.comp_lot.craftalos.program.IdentNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.program.node.VarDecNode;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.BlockCloseBlock;
import net.comp_lot.craftalos.system.program.block.BlockOpenBlock;
import net.comp_lot.craftalos.system.program.block.FunDecBlock;
import net.comp_lot.craftalos.system.program.block.MainBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class FunDecNode
extends IdentNode {
    private ProgramNode child;
    private List<VarDecNode> argumentsList = new ArrayList<VarDecNode>();
    private Map<String, VarDecNode> argumentsMap = new HashMap<String, VarDecNode>();

    public FunDecNode(ProgramNode parent, int srcAt, String ident) {
        super(parent, srcAt, ident);
    }

    public void setChild(ProgramNode child) {
        this.child = child;
    }

    public void addArgument(VarDecNode arg) {
        this.argumentsList.add(arg);
        this.argumentsMap.put(arg.getIdent(), arg);
    }

    public int getArgumentsNum() {
        return this.argumentsList.size();
    }

    public String[] getArgumentsNames() {
        return this.argumentsList.stream().map(arg -> arg.getIdent()).collect(Collectors.toList()).toArray(new String[this.getArgumentsNum()]);
    }

    public void setArgument(int index, double value) {
        this.argumentsList.get(index).setValue(value);
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        return this.child.execute();
    }

    @Override
    public FunDecNode clone(ProgramNode parent) {
        return new FunDecNode(parent, this.getSrcAt(), this.getIdent()).copy(this);
    }

    @Override
    protected FunDecNode copy(ProgramNode original) {
        super.copy(original);
        FunDecNode node = (FunDecNode)original;
        if (node.child != null) {
            this.child = node.child.clone(this);
        }
        node.argumentsList.stream().forEach(n -> this.addArgument(n.clone(this)));
        return this;
    }

    @Override
    public VarDecNode getVariable(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (this.argumentsMap.containsKey(ident)) {
            return this.argumentsMap.get(ident);
        }
        return super.getVariable(ident, srcAt);
    }

    @Override
    public List<ProgramBlock> convertToBlocks(DisplayInfo display, ProgramMode editer) {
        BlockCloseBlock funcEnd;
        BlockOpenBlock funcDec;
        ArrayList<ProgramBlock> list = new ArrayList<ProgramBlock>();
        if (this.getIdent().equals("main")) {
            funcDec = new MainBlock(display);
            funcEnd = new BlockCloseBlock(display, ProgramBlock.COLOR_EVENT, "}", 16);
            funcDec.getComponent().setClickListener(null);
            funcEnd.getComponent().setClickListener(null);
        } else {
            funcDec = new FunDecBlock(display, editer);
            funcDec.setValue(0, this.getIdent());
            funcDec.setValue(1, String.valueOf(this.argumentsList.size()));
            int i = 0;
            while (i < this.getArgumentsNum()) {
                funcDec.setValue(2 + i, this.argumentsList.get(i).getIdent());
                ++i;
            }
            funcEnd = new BlockCloseBlock(display, ProgramBlock.COLOR_FUN, "}", 16);
        }
        list.add(funcDec);
        this.child.convertToBlocks(display, editer).stream().forEach(list::add);
        list.add(funcEnd);
        ProgramBlock.setLink(funcDec, funcEnd);
        return list;
    }
}

