/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.comp_lot.craftalos.program.IdentNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.program.node.AryDecNode;
import net.comp_lot.craftalos.program.node.VarDecNode;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.BlockCloseBlock;
import net.comp_lot.craftalos.system.program.block.BlockOpenBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class BlockNode
extends ProgramNode {
    private List<ProgramNode> children = new ArrayList<ProgramNode>();
    private Map<String, VarDecNode> variables = new HashMap<String, VarDecNode>();
    private Map<String, AryDecNode> arrays = new HashMap<String, AryDecNode>();

    public BlockNode(ProgramNode parent, int srcAt) {
        super(parent, srcAt);
    }

    public void addChild(ProgramNode child) {
        IdentNode node;
        this.children.add(child);
        if (child instanceof VarDecNode) {
            node = (VarDecNode)child;
            this.variables.put(node.getIdent(), (VarDecNode)node);
        }
        if (child instanceof AryDecNode) {
            node = (AryDecNode)child;
            this.arrays.put(node.getIdent(), (AryDecNode)node);
        }
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        for (ProgramNode n : this.children) {
            ProgramNode.Result r = n.execute();
            if (!r.isReturn()) continue;
            return r;
        }
        return ProgramNode.Result.getNormalResult(0.0);
    }

    @Override
    public BlockNode clone(ProgramNode parent) {
        return new BlockNode(parent, this.getSrcAt()).copy(this);
    }

    @Override
    protected BlockNode copy(ProgramNode original) {
        super.copy(original);
        BlockNode node = (BlockNode)original;
        node.children.stream().forEach(n -> this.addChild(n.clone(this)));
        return this;
    }

    @Override
    public VarDecNode getVariable(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (this.variables.containsKey(ident)) {
            return this.variables.get(ident);
        }
        return super.getVariable(ident, srcAt);
    }

    @Override
    protected AryDecNode getArray(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (this.arrays.containsKey(ident)) {
            return this.arrays.get(ident);
        }
        return super.getArray(ident, srcAt);
    }

    @Override
    public List<ProgramBlock> convertToBlocks(DisplayInfo display, ProgramMode editer) {
        ArrayList<ProgramBlock> list = new ArrayList<ProgramBlock>();
        if (this.getParent() instanceof BlockNode) {
            BlockOpenBlock startBlock = new BlockOpenBlock(display);
            BlockCloseBlock endBlock = new BlockCloseBlock(display);
            list.add(startBlock);
            this.children.stream().flatMap(n -> n.convertToBlocks(display, editer).stream()).forEach(list::add);
            list.add(endBlock);
            ProgramBlock.setLink(startBlock, endBlock);
        } else {
            this.children.stream().flatMap(n -> n.convertToBlocks(display, editer).stream()).forEach(list::add);
        }
        return list;
    }
}

