/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import net.comp_lot.craftalos.program.IdentNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.program.node.AryDecNode;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.AryBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class AryNode
extends IdentNode {
    private ProgramNode child;

    public AryNode(ProgramNode parent, int srcAt, String ident) {
        super(parent, srcAt, ident);
    }

    public void setChild(ProgramNode child) {
        this.child = child;
    }

    public ProgramNode getChild() {
        return this.child;
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        return ProgramNode.Result.getNormalResult(this.getArrayDec().getValue(this.getIndex(), this.getSrcAt()));
    }

    private AryDecNode getArrayDec() throws MachineProgram.ProgramException {
        return this.getArray(this.getIdent(), this.getSrcAt());
    }

    public void setValue(double value) throws MachineProgram.ProgramException {
        this.getArrayDec().setValue(this.getIndex(), value, this.getSrcAt());
    }

    public int getIndex() throws MachineProgram.ProgramException {
        return (int)this.child.execute().getValue();
    }

    @Override
    public AryNode clone(ProgramNode parent) {
        return new AryNode(parent, this.getSrcAt(), this.getIdent()).copy(this);
    }

    @Override
    protected AryNode copy(ProgramNode original) {
        super.copy(original);
        this.child = ((AryNode)original).child.clone(this);
        return this;
    }

    @Override
    public ProgramBlock convertToBlock(DisplayInfo display, ProgramMode editor) {
        AryBlock rtn = new AryBlock(display, editor);
        rtn.setValue(0, this.getIdent());
        rtn.setValue(1, this.child.convertToBlock(display, editor));
        return rtn;
    }
}

