/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.node;

import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.IdentNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.AryDecBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class AryDecNode
extends IdentNode {
    private static final int MAX_SIZE = 0x40000000;
    private double[] array;
    private ProgramNode child;

    public AryDecNode(ProgramNode parent, int srcAt, String ident) {
        super(parent, srcAt, ident);
    }

    public void setChild(ProgramNode child) {
        this.child = child;
    }

    @Override
    protected ProgramNode.Result run() throws MachineProgram.ProgramException {
        int size = (int)this.child.execute().getValue();
        if (size < 0 || size >= 0x40000000) {
            this.array = new double[0];
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorArrayIllegalSize(size), this.getSrcAt());
        }
        this.array = new double[size];
        return ProgramNode.Result.getNormalResult(0.0);
    }

    public double getValue(int index, int srcAt) throws MachineProgram.ProgramException {
        if (index < 0 || index >= this.array.length) {
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorArrayOutOfRange(index, this.getIdent(), this.array.length), srcAt);
        }
        return this.array[index];
    }

    public void setValue(int index, double value, int srcAt) throws MachineProgram.ProgramException {
        if (index < 0 || index >= this.array.length) {
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorArrayOutOfRange(index, this.getIdent(), this.array.length), srcAt);
        }
        this.array[index] = value;
    }

    @Override
    public AryDecNode clone(ProgramNode parent) {
        return new AryDecNode(parent, this.getSrcAt(), this.getIdent()).copy(this);
    }

    @Override
    protected AryDecNode copy(ProgramNode original) {
        super.copy(original);
        this.child = ((AryDecNode)original).child.clone(this);
        return this;
    }

    @Override
    public ProgramBlock convertToBlock(DisplayInfo display, ProgramMode editer) {
        AryDecBlock rtn = new AryDecBlock(display);
        rtn.setValue(0, this.getIdent());
        rtn.setValue(1, this.child.convertToBlock(display, editer));
        return rtn;
    }
}

