/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.compiler;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.Token;

class Tokenizer {
    private static final String[] RESERVED = new String[]{"<=", ">=", "==", "!=", "&&", "||", "*", "/", "%", "+", "-", "<", ">", "!", "=", ";", ",", ":", "(", ")", "{", "}", "[", "]", "#"};
    private final String source;
    private int point = 0;
    private final List<Token> list = new ArrayList<Token>();

    private Tokenizer(String source) {
        this.source = source + " ";
    }

    public static List<Token> tokenize(String source) throws CompileException {
        return new Tokenizer(source).tokenize();
    }

    private List<Token> tokenize() throws CompileException {
        while (true) {
            char c;
            if (this.point >= this.source.length()) {
                this.list.add(new Token(Token.Kind.TK_EOF, "", this.source.length() - 2));
                return this.list;
            }
            if (this.point + 1 < this.source.length()) {
                if (this.source.startsWith("//", this.point)) {
                    this.point = this.source.indexOf(10, this.point + 2);
                    if (this.point < 0) {
                        this.point = this.source.length();
                        continue;
                    }
                } else if (this.source.startsWith("/*", this.point)) {
                    this.point = this.source.indexOf("*/", this.point + 2) + 2;
                    if (this.point < 0) {
                        this.point = this.source.length();
                        continue;
                    }
                }
            }
            if ((c = this.source.charAt(this.point)) == ' ' || c == '\n' || c == '\t') {
                ++this.point;
                continue;
            }
            if (!(this.tokenizeReserved() || this.tokenizeNumber() || this.tokenizeString() || this.tokenizeIdentifier())) break;
        }
        throw new CompileException("[Tokenize error] Character '" + this.source.charAt(this.point) + "' cannot tokenize", this.point);
    }

    private boolean tokenizeReserved() {
        int i = 0;
        while (i < RESERVED.length) {
            if (this.source.startsWith(RESERVED[i], this.point)) {
                this.list.add(new Token(Token.Kind.TK_RESERVED, RESERVED[i], this.point));
                this.point += RESERVED[i].length();
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean tokenizeString() {
        if (this.source.charAt(this.point) != '\"') {
            return false;
        }
        int endPoint = this.source.indexOf(34, this.point + 1);
        if (endPoint < 0) {
            return false;
        }
        this.list.add(new Token(Token.Kind.TK_STRING, this.source.substring(this.point, endPoint + 1), this.point));
        this.point = endPoint + 1;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean tokenizeNumber() {
        block4: {
            if (this.source.charAt(this.point) == '$') {
                this.list.add(new Token(Token.Kind.TK_NUM, "", this.point++, 0.0f));
                return true;
            }
            if (!Character.isDigit(this.source.charAt(this.point))) {
                return false;
            }
            endPoint = this.point;
            while (Character.isDigit(this.source.charAt(endPoint))) {
                ++endPoint;
            }
            if (this.source.charAt(endPoint) != '.') break block4;
            if (Character.isDigit(this.source.charAt(++endPoint))) ** GOTO lbl15
            return false;
lbl-1000:
            // 1 sources

            {
                ++endPoint;
lbl15:
                // 2 sources

                ** while (Character.isDigit((char)this.source.charAt((int)endPoint)))
            }
        }
        str = this.source.substring(this.point, endPoint);
        this.list.add(new Token(Token.Kind.TK_NUM, str, this.point, Float.parseFloat(str)));
        this.point = endPoint;
        return true;
    }

    private boolean tokenizeIdentifier() {
        if (!('a' <= this.source.charAt(this.point) && this.source.charAt(this.point) <= 'z' || 'A' <= this.source.charAt(this.point) && this.source.charAt(this.point) <= 'Z' || this.source.charAt(this.point) == '_')) {
            return false;
        }
        int endPoint = this.point;
        while ('a' <= this.source.charAt(endPoint) && this.source.charAt(endPoint) <= 'z' || 'A' <= this.source.charAt(endPoint) && this.source.charAt(endPoint) <= 'Z' || Character.isDigit(this.source.charAt(endPoint)) || this.source.charAt(endPoint) == '_') {
            ++endPoint;
        }
        String ident = this.source.substring(this.point, endPoint);
        this.list.add(new Token(Token.Kind.TK_IDENT, ident.equals("_") ? "" : ident, this.point));
        this.point = endPoint;
        return true;
    }
}

