/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.compiler;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.program.BinaryNode;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.Parser;
import net.comp_lot.craftalos.program.compiler.Token;
import net.comp_lot.craftalos.program.node.AddNode;
import net.comp_lot.craftalos.program.node.AndNode;
import net.comp_lot.craftalos.program.node.AryDecNode;
import net.comp_lot.craftalos.program.node.AryNode;
import net.comp_lot.craftalos.program.node.BlockNode;
import net.comp_lot.craftalos.program.node.DivNode;
import net.comp_lot.craftalos.program.node.EqNode;
import net.comp_lot.craftalos.program.node.FunDecNode;
import net.comp_lot.craftalos.program.node.FunNode;
import net.comp_lot.craftalos.program.node.IfNode;
import net.comp_lot.craftalos.program.node.IncludeNode;
import net.comp_lot.craftalos.program.node.LsNode;
import net.comp_lot.craftalos.program.node.LseNode;
import net.comp_lot.craftalos.program.node.MulNode;
import net.comp_lot.craftalos.program.node.NeqNode;
import net.comp_lot.craftalos.program.node.NotNode;
import net.comp_lot.craftalos.program.node.NumNode;
import net.comp_lot.craftalos.program.node.OrNode;
import net.comp_lot.craftalos.program.node.ReturnNode;
import net.comp_lot.craftalos.program.node.SetNode;
import net.comp_lot.craftalos.program.node.StringNode;
import net.comp_lot.craftalos.program.node.SubNode;
import net.comp_lot.craftalos.program.node.TopNode;
import net.comp_lot.craftalos.program.node.VarDecNode;
import net.comp_lot.craftalos.program.node.VarNode;
import net.comp_lot.craftalos.program.node.WhileNode;

class ProgramParser
extends Parser {
    private ProgramParser(List<Token> tokens) {
        super(tokens);
    }

    static void parse(List<Token> tokens, TopNode top) throws CompileException {
        new ProgramParser(tokens).parseProgram(top);
    }

    static List<ProgramNode> parseCopy(List<Token> tokens) throws CompileException {
        return new ProgramParser(tokens).parseIgnorePlace();
    }

    private List<ProgramNode> parseIgnorePlace() throws CompileException {
        ArrayList<ProgramNode> list = new ArrayList<ProgramNode>();
        while (!this.isEnd()) {
            list.add(this.parseSingleIgnorePlace());
        }
        return list;
    }

    private ProgramNode parseSingleIgnorePlace() throws CompileException {
        if (this.consume("#")) {
            this.expect("include");
            IncludeNode includeNode = new IncludeNode(null, this.getPosition(-2), this.expectString());
            this.consume(";");
            return includeNode;
        }
        String type = this.consumeType();
        if (type != null) {
            String ident = this.expectIdent();
            if (this.consume("(")) {
                return this.funDec(null, ident);
            }
            ProgramNode varDec = this.varDecOrAryDec(null, ident);
            this.consume(";");
            return varDec;
        }
        if (this.consume("return")) {
            ReturnNode rtn = new ReturnNode(null, this.getPosition(-1));
            rtn.setChild(this.expr(null));
            this.consume(";");
            return rtn;
        }
        ProgramNode block = this.consumeBlock(null);
        if (block != null) {
            return block;
        }
        ProgramNode expr = this.expr(null);
        this.consume(";");
        return expr;
    }

    private void parseProgram(TopNode top) throws CompileException {
        while (!this.isEnd()) {
            if (this.consume("#")) {
                this.expect("include");
                top.addChild(new IncludeNode(top, this.getPosition(-2), this.expectString()));
                continue;
            }
            this.expectType();
            String ident = this.expectIdent();
            if (this.consume("(")) {
                top.addChild(this.funDec(top, ident));
                continue;
            }
            top.addChild(this.varDecOrAryDec(top, ident));
            this.expect(";");
        }
    }

    private FunDecNode funDec(TopNode top, String ident) throws CompileException {
        FunDecNode fun = new FunDecNode(top, this.getPosition(-2), ident);
        String argType = this.consumeType();
        if (argType != null) {
            String argIdent = this.expectIdent();
            fun.addArgument(new VarDecNode(fun, this.getPosition(-2), argIdent));
            while (this.consume(",")) {
                argType = this.expectType();
                argIdent = this.expectIdent();
                fun.addArgument(new VarDecNode(fun, this.getPosition(-2), argIdent));
            }
        }
        this.expect(")");
        fun.setChild(this.stmt(fun));
        return fun;
    }

    private ProgramNode stmt(ProgramNode parent) throws CompileException {
        ProgramNode block = this.consumeBlock(parent);
        if (block != null) {
            return block;
        }
        if (this.consume("return")) {
            ReturnNode rtn = new ReturnNode(parent, this.getPosition(-1));
            rtn.setChild(this.expr(parent));
            this.expect(";");
            return rtn;
        }
        String type = this.consumeType();
        if (type != null) {
            ProgramNode node = this.varDecOrAryDec(parent, this.expectIdent());
            this.expect(";");
            return node;
        }
        ProgramNode node = this.expr(parent);
        this.expect(";");
        return node;
    }

    private ProgramNode varDecOrAryDec(ProgramNode parent, String ident) throws CompileException {
        if (this.consume("[")) {
            AryDecNode ary = new AryDecNode(parent, this.getPosition(-3), ident);
            ary.setChild(this.expr(ary));
            this.expect("]");
            return ary;
        }
        VarDecNode var = new VarDecNode(parent, this.getPosition(-2), ident);
        if (this.consume("=")) {
            var.setInit(this.expr(var));
        }
        return var;
    }

    private ProgramNode consumeBlock(ProgramNode parent) throws CompileException {
        if (this.consume("{")) {
            BlockNode node = new BlockNode(parent, this.getPosition(-1));
            while (!this.consume("}")) {
                node.addChild(this.stmt(node));
            }
            return node;
        }
        if (this.consumeWord("if")) {
            IfNode node = new IfNode(parent, this.getPosition(-1));
            this.expect("(");
            node.setCond(this.expr(node));
            this.expect(")");
            node.setIf(this.stmt(node));
            if (this.consumeWord("else")) {
                node.setElse(this.stmt(node));
            }
            return node;
        }
        if (this.consumeWord("while")) {
            WhileNode node = new WhileNode(parent, this.getPosition(-1));
            this.expect("(");
            node.setCond(this.expr(node));
            this.expect(")");
            node.setChild(this.stmt(node));
            return node;
        }
        return null;
    }

    private ProgramNode expr(ProgramNode parent) throws CompileException {
        ProgramNode node = this.setCal(parent);
        return node;
    }

    private ProgramNode setCal(ProgramNode parent) throws CompileException {
        ProgramNode node = this.orCal(parent);
        if (this.consume("=")) {
            SetNode set = new SetNode(parent, this.getPosition(-1));
            set.setChildren(node, this.setCal(parent));
            return set;
        }
        return node;
    }

    private ProgramNode orCal(ProgramNode parent) throws CompileException {
        ProgramNode node = this.andCal(parent);
        while (this.consume("||")) {
            OrNode or = new OrNode(parent, this.getPosition(-1));
            or.setChildren(node, this.andCal(parent));
            node = or;
        }
        return node;
    }

    private ProgramNode andCal(ProgramNode parent) throws CompileException {
        ProgramNode node = this.notCal(parent);
        while (this.consume("&&")) {
            AndNode and = new AndNode(parent, this.getPosition(-1));
            and.setChildren(node, this.notCal(parent));
            node = and;
        }
        return node;
    }

    private ProgramNode notCal(ProgramNode parent) throws CompileException {
        if (this.consume("!")) {
            NotNode not = new NotNode(parent, this.getPosition(-1));
            not.setChild(this.eqCal(parent));
            return not;
        }
        return this.eqCal(parent);
    }

    private ProgramNode eqCal(ProgramNode parent) throws CompileException {
        ProgramNode node = this.relCal(parent);
        while (true) {
            if (this.consume("==")) {
                EqNode eq = new EqNode(parent, this.getPosition(-1));
                eq.setChildren(node, this.relCal(parent));
                node = eq;
                continue;
            }
            if (!this.consume("!=")) break;
            NeqNode neq = new NeqNode(parent, this.getPosition(-1));
            neq.setChildren(node, this.relCal(parent));
            node = neq;
        }
        return node;
    }

    private ProgramNode relCal(ProgramNode parent) throws CompileException {
        ProgramNode node = this.addCal(parent);
        while (true) {
            BinaryNode rel;
            if (this.consume("<")) {
                rel = new LsNode(parent, this.getPosition(-1));
                rel.setChildren(node, this.addCal(parent));
                node = rel;
                continue;
            }
            if (this.consume("<=")) {
                rel = new LseNode(parent, this.getPosition(-1));
                rel.setChildren(node, this.addCal(parent));
                node = rel;
                continue;
            }
            if (this.consume(">")) {
                rel = new LsNode(parent, this.getPosition(-1));
                rel.setChildren(this.addCal(parent), node);
                node = rel;
                continue;
            }
            if (!this.consume(">=")) break;
            rel = new LseNode(parent, this.getPosition(-1));
            rel.setChildren(this.addCal(parent), node);
            node = rel;
        }
        return node;
    }

    private ProgramNode addCal(ProgramNode parent) throws CompileException {
        ProgramNode node = this.mulCal(parent);
        while (true) {
            BinaryNode add;
            if (this.consume("+")) {
                add = new AddNode(parent, this.getPosition(-1));
                add.setChildren(node, this.mulCal(parent));
                node = add;
                continue;
            }
            if (!this.consume("-")) break;
            add = new SubNode(parent, this.getPosition(-1));
            add.setChildren(node, this.mulCal(parent));
            node = add;
        }
        return node;
    }

    private ProgramNode mulCal(ProgramNode parent) throws CompileException {
        ProgramNode node = this.unary(parent);
        while (true) {
            BinaryNode mul;
            if (this.consume("*")) {
                mul = new MulNode(parent, this.getPosition(-1));
                mul.setChildren(node, this.unary(parent));
                node = mul;
                continue;
            }
            if (!this.consume("/")) break;
            mul = new DivNode(parent, this.getPosition(-1));
            mul.setChildren(node, this.unary(parent));
            node = mul;
        }
        return node;
    }

    private ProgramNode unary(ProgramNode parent) throws CompileException {
        if (this.consume("-")) {
            String d = this.consumeNumber();
            if (d != null) {
                return new NumNode(parent, this.getPosition(-2), "-" + d);
            }
            SubNode sub = new SubNode(parent, this.getPosition(-1));
            sub.setChildren(new NumNode(parent, this.getPosition(-1), "0"), this.term(parent));
            return sub;
        }
        this.consume("+");
        return this.term(parent);
    }

    private ProgramNode term(ProgramNode parent) throws CompileException {
        if (this.consume("(")) {
            ProgramNode node = this.expr(parent);
            this.expect(")");
            return node;
        }
        String ident = this.consumeIdent();
        if (ident != null) {
            if (this.consume("(")) {
                FunNode fun = new FunNode(parent, this.getPosition(-2), ident);
                if (!this.consume(")")) {
                    do {
                        fun.addChild(this.expr(parent));
                    } while (this.consume(","));
                    this.expect(")");
                }
                return fun;
            }
            if (this.consume("[")) {
                AryNode ary = new AryNode(parent, this.getPosition(-2), ident);
                ary.setChild(this.expr(parent));
                this.expect("]");
                return ary;
            }
            return new VarNode(parent, this.getPosition(-1), ident);
        }
        String s = this.consumeString();
        if (s != null) {
            return new StringNode(parent, this.getPosition(-1), s);
        }
        return new NumNode(parent, this.getPosition(0), this.expectNumberAsString());
    }
}

