/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.compiler;

import java.util.List;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.Token;

abstract class Parser {
    private final List<Token> tokens;
    private int point = 0;

    protected Parser(List<Token> tokens) {
        this.tokens = tokens;
    }

    void pointBack(int num) {
        this.point -= num;
    }

    boolean consume(String op) {
        if (this.point < this.tokens.size() && this.tokens.get((int)this.point).str.equals(op)) {
            ++this.point;
            return true;
        }
        return false;
    }

    String consumeIdent() {
        if (this.point < this.tokens.size() && this.tokens.get((int)this.point).kind == Token.Kind.TK_IDENT) {
            return this.tokens.get((int)this.point++).str;
        }
        return null;
    }

    boolean consumeWord(String word) {
        if (this.point < this.tokens.size() && this.tokens.get((int)this.point).kind == Token.Kind.TK_IDENT && this.tokens.get((int)this.point).str.equals(word)) {
            ++this.point;
            return true;
        }
        return false;
    }

    String consumeType() {
        String type;
        if (this.point < this.tokens.size() && this.tokens.get((int)this.point).kind == Token.Kind.TK_IDENT && (type = this.tokens.get((int)this.point).str).equals("float")) {
            ++this.point;
            return type;
        }
        return null;
    }

    String consumeNumber() {
        if (this.point < this.tokens.size() && this.tokens.get((int)this.point).kind == Token.Kind.TK_NUM) {
            Token num = this.tokens.get(this.point++);
            return num.str;
        }
        return null;
    }

    String consumeString() {
        if (this.point < this.tokens.size() && this.tokens.get((int)this.point).kind == Token.Kind.TK_STRING) {
            Token str = this.tokens.get(this.point++);
            return str.str.substring(1, str.str.length() - 1);
        }
        return null;
    }

    void expect(String op) throws CompileException {
        if (!this.consume(op)) {
            throw new CompileException("[Parse error] \"" + op + "\" not found", this.getPosition());
        }
    }

    double expectNumber() throws CompileException {
        if (this.tokens.get((int)this.point).kind != Token.Kind.TK_NUM) {
            throw new CompileException("[Parse error] Value not found", this.getPosition());
        }
        return this.tokens.get((int)this.point++).val;
    }

    String expectNumberAsString() throws CompileException {
        if (this.tokens.get((int)this.point).kind != Token.Kind.TK_NUM) {
            throw new CompileException("[Parse error] Value not found", this.getPosition());
        }
        return this.tokens.get((int)this.point++).str;
    }

    String expectIdent() throws CompileException {
        String ident = this.consumeIdent();
        if (ident == null) {
            throw new CompileException("[Parse error] Identity not found", this.getPosition());
        }
        return ident;
    }

    String expectType() throws CompileException {
        String type = this.consumeIdent();
        if (type == null) {
            throw new CompileException("[Parse error] Type not found", this.getPosition());
        }
        if (!type.equals("float")) {
            throw new CompileException("[Parse error] Unknown type : " + type, this.getPosition());
        }
        return type;
    }

    String expectString() throws CompileException {
        String str = this.consumeString();
        if (str == null) {
            throw new CompileException("[Parse error] String not found", this.getPosition());
        }
        return str;
    }

    protected int getPosition(int offset) {
        return this.tokens.get((int)(this.point + offset)).at;
    }

    protected int getPosition() {
        return this.getPosition(0);
    }

    boolean isEnd() {
        return this.tokens.get((int)this.point).kind == Token.Kind.TK_EOF;
    }
}

