/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.compiler;

import java.util.List;
import java.util.function.Consumer;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.node.NumNode;
import net.comp_lot.craftalos.program.node.StdFunDecNode;
import net.comp_lot.craftalos.program.node.TopNode;
import net.comp_lot.craftalos.program.node.VarDecNode;
import net.comp_lot.glui.system.OperationEvent;

public class MachineProgram
implements Runnable {
    private static final double E_RANGE = 1.0E-4;
    private final TopNode program = new TopNode();
    private Machine machine;
    private Consumer<String> printer = s -> this.machine.print((String)s);
    private final String source;

    public TopNode getTopNode() {
        return this.program;
    }

    MachineProgram(String source) {
        this.setStdFunction();
        this.source = source;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
        List<FunctionalBlock> fb = machine.getFunctionalBlocks();
        int i = 1;
        while (i < fb.size()) {
            VarDecNode node = new VarDecNode(this.program, -1, fb.get(i).getIdent());
            node.setInit(new NumNode(node, -1, String.valueOf(i)));
            this.program.addChildToTop(node);
            ++i;
        }
        OperationEvent.KeyCode[] values = OperationEvent.KeyCode.values();
        int i2 = 0;
        while (i2 < values.length) {
            VarDecNode node = new VarDecNode(this.program, -1, "_" + values[i2].name());
            node.setInit(new NumNode(node, -1, String.valueOf(i2)));
            this.program.addChildToTop(node);
            ++i2;
        }
        try {
            this.program.runInit();
        }
        catch (ProgramException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    private void setStdFunction() {
        this.program.addChildToTop(new StdFunDecNode(this.program, "_get", context -> {
            try {
                return ProgramNode.Result.getNormalResult(this.machine.getBlockValue((int)context.getVariable("block", -1).getValue()));
            }
            catch (IndexOutOfBoundsException e) {
                throw new ProgramException(StringManager.lang.runtimeErrorUnknownBlockId((int)context.getVariable("block", -1).getValue()), -1);
            }
        }, "block"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_set", context -> {
            try {
                this.machine.setBlockValue((int)context.getVariable("block", -1).getValue(), context.getVariable("value", -1).getValue());
                return ProgramNode.Result.getNormalResult(0.0);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ProgramException(StringManager.lang.runtimeErrorUnknownBlockId((int)context.getVariable("block", -1).getValue()), -1);
            }
        }, "block", "value"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_key", context -> {
            OperationEvent.KeyCode code = OperationEvent.KeyCode.toKeyCode((int)context.getVariable("key", -1).getValue());
            if (code == null) {
                throw new ProgramException(StringManager.lang.runtimeErrorUnknownKeyCode((int)context.getVariable("key", -1).getValue()), -1);
            }
            return ProgramNode.Result.getNormalResult(this.machine.getKeyState(code) ? 1 : 0);
        }, "key"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_keyDown", context -> {
            OperationEvent.KeyCode code = OperationEvent.KeyCode.toKeyCode((int)context.getVariable("key", -1).getValue());
            if (code == null) {
                throw new ProgramException(StringManager.lang.runtimeErrorUnknownKeyCode((int)context.getVariable("key", -1).getValue()), -1);
            }
            return ProgramNode.Result.getNormalResult(this.machine.getKeyDown(code) ? 1 : 0);
        }, "key"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_print", context -> {
            this.printer.accept(String.format("%.2f, %.2f, %.2f", context.getVariable("arg1", -1).getValue(), context.getVariable("arg2", -1).getValue(), context.getVariable("arg3", -1).getValue()));
            return ProgramNode.Result.getNormalResult(0.0);
        }, "arg1", "arg2", "arg3"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_sin_rad", context -> ProgramNode.Result.getNormalResult(Math.sin(context.getVariable("rad", -1).getValue())), "rad"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_cos_rad", context -> ProgramNode.Result.getNormalResult(Math.cos(context.getVariable("rad", -1).getValue())), "rad"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_tan_rad", context -> ProgramNode.Result.getNormalResult(Math.tan(context.getVariable("rad", -1).getValue())), "rad"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_asin_rad", context -> ProgramNode.Result.getNormalResult(Math.asin(MachineProgram.range(context.getVariable("a", -1).getValue(), -1.0, 1.0))), "a"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_acos_rad", context -> ProgramNode.Result.getNormalResult(Math.acos(MachineProgram.range(context.getVariable("a", -1).getValue(), -1.0, 1.0))), "a"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_atan_rad", context -> ProgramNode.Result.getNormalResult(Math.atan(context.getVariable("a", -1).getValue())), "a"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_sin", context -> ProgramNode.Result.getNormalResult(Math.sin(Math.toRadians(context.getVariable("deg", -1).getValue()))), "deg"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_cos", context -> ProgramNode.Result.getNormalResult(Math.cos(Math.toRadians(context.getVariable("deg", -1).getValue()))), "deg"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_tan", context -> ProgramNode.Result.getNormalResult(Math.tan(Math.toRadians(context.getVariable("deg", -1).getValue()))), "deg"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_asin", context -> ProgramNode.Result.getNormalResult(Math.toDegrees(Math.asin(MachineProgram.range(context.getVariable("a", -1).getValue(), -1.0, 1.0)))), "a"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_acos", context -> ProgramNode.Result.getNormalResult(Math.toDegrees(Math.acos(MachineProgram.range(context.getVariable("a", -1).getValue(), -1.0, 1.0)))), "a"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_atan", context -> ProgramNode.Result.getNormalResult(Math.toDegrees(Math.atan(context.getVariable("a", -1).getValue()))), "a"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_sqrt", context -> ProgramNode.Result.getNormalResult(Math.sqrt(context.getVariable("a", -1).getValue())), "a"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_exp", context -> ProgramNode.Result.getNormalResult(Math.exp(context.getVariable("a", -1).getValue())), "a"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "_log", context -> ProgramNode.Result.getNormalResult(Math.log(context.getVariable("a", -1).getValue())), "a"));
    }

    private static double range(double value, double min, double max) throws ProgramException {
        if (value >= min && value <= max) {
            return value;
        }
        if (value > max && value < max + 1.0E-4) {
            return max;
        }
        if (value < min && value > min - 1.0E-4) {
            return min;
        }
        throw new ProgramException(StringManager.lang.runtimeErrorValueOutOfRange(value, min, max), -1);
    }

    public void setPrinter(Consumer<String> printer) {
        this.printer = printer;
    }

    @Override
    public void run() {
        try {
            this.program.launch();
        }
        catch (ProgramException e) {
            this.printer.accept(e.getDetailMessage(this.source));
        }
    }

    public static class ProgramException
    extends Exception {
        private static final long serialVersionUID = -7715390497813724680L;
        private final int srcAt;

        public ProgramException(String msg, int srcAt) {
            super(msg);
            this.srcAt = srcAt;
        }

        public int getSrcAt() {
            return this.srcAt;
        }

        public String getDetailMessage(String source) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getLocalizedMessage());
            if (this.srcAt >= 0) {
                int count = 0;
                int rowStart = 0;
                int row = 1;
                int col = 1;
                while (count < this.srcAt) {
                    if (source.charAt(count++) == '\n') {
                        rowStart = count;
                        ++row;
                        col = 1;
                        continue;
                    }
                    ++col;
                }
                sb.append("\nat: row ");
                sb.append(row);
                sb.append(", col ");
                sb.append(col);
                sb.append("\n");
                if (rowStart < this.srcAt - 40) {
                    rowStart = this.srcAt - 40;
                    sb.append("...");
                }
                while (rowStart < source.length() && source.charAt(rowStart) != '\n' && rowStart < this.srcAt + 40) {
                    sb.append(source.charAt(rowStart++));
                }
                if (source.charAt(rowStart) != '\n') {
                    sb.append("...");
                }
            } else {
                sb.append("\nat: internal code");
            }
            return sb.toString();
        }
    }
}

