/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.compiler;

import java.util.List;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.ConnectionBlock;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.game.model.parts.CameraBlock;
import net.comp_lot.craftalos.game.model.parts.CoreBlock;
import net.comp_lot.craftalos.game.model.parts.DistanceSensorBlock;
import net.comp_lot.craftalos.game.model.parts.FcsBlock;
import net.comp_lot.craftalos.game.model.parts.GrenadeBlock;
import net.comp_lot.craftalos.game.model.parts.HorizontalBlock;
import net.comp_lot.craftalos.game.model.parts.LightSensorBlock;
import net.comp_lot.craftalos.game.model.parts.LinkBlock;
import net.comp_lot.craftalos.game.model.parts.MachineGunBlock;
import net.comp_lot.craftalos.game.model.parts.MotorBlock;
import net.comp_lot.craftalos.game.model.parts.MouseAxisBlock;
import net.comp_lot.craftalos.game.model.parts.NormalBlock;
import net.comp_lot.craftalos.game.model.parts.RailBlock;
import net.comp_lot.craftalos.game.model.parts.RifleBlock;
import net.comp_lot.craftalos.game.model.parts.SpeedSensorBlock;
import net.comp_lot.craftalos.game.model.parts.SuperMotorBlock;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.Parser;
import net.comp_lot.craftalos.program.compiler.Token;
import net.comp_lot.glui.amount.MutVector;

class MachineParser
extends Parser {
    private final Machine machine;

    private MachineParser(List<Token> tokens, Machine machine) {
        super(tokens);
        this.machine = machine;
    }

    static void parse(List<Token> tokens, Machine machine) throws CompileException {
        Part p = new Part(machine);
        p.setActive(-1.0);
        new MachineParser(tokens, machine).parts(p);
        machine.addPart(p);
    }

    private void parts(Part parts) throws CompileException {
        this.expect("{");
        while (!this.consume("}")) {
            Block b = null;
            Part p = null;
            String type = this.expectIdent();
            this.expect("(");
            switch (type) {
                case "NormalBlock": {
                    b = new NormalBlock((int)this.expectNumber());
                    this.expect(",");
                    String color = this.consumeString();
                    if (color == null) break;
                    ((NormalBlock)b).setColor(color);
                    this.expect(",");
                    break;
                }
                case "MotorBlock": {
                    p = new Part(this.machine);
                    b = new MotorBlock(this.machine, this.expectIdent(), parts, p);
                    this.expect(",");
                    break;
                }
                case "SuperMotorBlock": {
                    p = new Part(this.machine);
                    b = new SuperMotorBlock(this.machine, this.expectIdent(), parts, p);
                    this.expect(",");
                    break;
                }
                case "CameraBlock": {
                    b = new CameraBlock(this.machine, this.expectIdent());
                    this.expect(",");
                    break;
                }
                case "LightSensorBlock": {
                    b = new LightSensorBlock(this.machine, this.expectIdent());
                    this.expect(",");
                    break;
                }
                case "DistanceSensorBlock": {
                    b = new DistanceSensorBlock(this.machine, this.expectIdent());
                    this.expect(",");
                    break;
                }
                case "SpeedSensorBlock": {
                    b = new SpeedSensorBlock(this.expectIdent());
                    this.expect(",");
                    break;
                }
                case "MouseAxisBlock": {
                    b = new MouseAxisBlock(this.machine, this.expectIdent());
                    this.expect(",");
                    break;
                }
                case "HorizontalBlock": {
                    b = new HorizontalBlock(this.machine, this.expectIdent());
                    this.expect(",");
                    break;
                }
                case "FcsBlock": {
                    b = new FcsBlock(this.machine, this.expectIdent());
                    this.expect(",");
                    break;
                }
                case "RifleBlock": {
                    String ident = this.expectIdent();
                    this.expect(",");
                    int length = (int)this.expectNumber();
                    b = new RifleBlock(this.machine, ident, length);
                    this.expect(",");
                    break;
                }
                case "MachineGunBlock": {
                    String ident = this.expectIdent();
                    this.expect(",");
                    int length = (int)this.expectNumber();
                    b = new MachineGunBlock(this.machine, ident, length);
                    this.expect(",");
                    break;
                }
                case "GrenadeBlock": {
                    String ident = this.expectIdent();
                    this.expect(",");
                    int length = (int)this.expectNumber();
                    b = new GrenadeBlock(this.machine, ident, length);
                    this.expect(",");
                    break;
                }
                case "RailBlock": {
                    String ident = this.expectIdent();
                    this.expect(",");
                    int length = (int)this.expectNumber();
                    b = new RailBlock(this.machine, ident, length);
                    this.expect(",");
                    break;
                }
                case "CoreBlock": {
                    b = new CoreBlock(this.expectIdent());
                    this.expect(",");
                    break;
                }
                case "LinkBlock": {
                    b = new LinkBlock(this.expectIdent());
                    this.expect(",");
                    break;
                }
                default: {
                    throw new CompileException("Unknown type : " + type, this.getPosition());
                }
            }
            if (b instanceof FunctionalBlock) {
                this.machine.addFunctionalBlocks(new FunctionalBlock[]{b});
            }
            if (b instanceof ConnectionBlock) {
                this.machine.addMachinePart(p);
            }
            this.place(b);
            this.expect(")");
            parts.addBlocks(b);
            if (p == null) continue;
            this.parts(p);
            parts.addPart(p);
        }
    }

    private void place(Block b) throws CompileException {
        MutVector[] v = new MutVector[4];
        int i = 0;
        while (i < v.length) {
            if (i != 0) {
                this.expect(",");
            }
            v[i] = this.vector();
            ++i;
        }
        b.getModel().setRotation(v[0], v[1], v[2]);
        b.getModel().moveP(v[3]);
    }

    private MutVector vector() throws CompileException {
        this.expect("(");
        double x = this.consume("-") ? -this.expectNumber() : this.expectNumber();
        this.expect(",");
        double y = this.consume("-") ? -this.expectNumber() : this.expectNumber();
        this.expect(",");
        double z = this.consume("-") ? -this.expectNumber() : this.expectNumber();
        this.expect(")");
        return new MutVector().set(x, y, z);
    }
}

