/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.compiler;

import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.Token;
import net.comp_lot.craftalos.program.compiler.Tokenizer;
import net.comp_lot.glui.system.utils.FileUtils;

public class Includer {
    private final Set<String> set = new HashSet<String>();

    public String include(String source) {
        StringBuilder sb = new StringBuilder();
        source.lines().map(this::includeLine).forEach(line -> {
            sb.append((String)line);
            sb.append("\n");
        });
        return sb.toString();
    }

    private String includeLine(String source) {
        try {
            List<Token> tokens = Tokenizer.tokenize(source);
            boolean changed = this.include(tokens);
            if (!changed) {
                return source;
            }
            StringBuilder sb = new StringBuilder();
            tokens.stream().forEach(t -> {
                sb.append(t.getStr());
                sb.append(' ');
            });
            return sb.toString();
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (CompileException e) {
            System.err.println(e.getMessage());
        }
        return source;
    }

    private boolean include(List<Token> tokens) throws FileNotFoundException, CompileException {
        boolean changed = false;
        int i = 0;
        while (i < tokens.size()) {
            if (tokens.get(i).getKind() == Token.Kind.TK_RESERVED && tokens.get(i).getStr().equals("#") && tokens.get(i + 1).getKind() == Token.Kind.TK_IDENT && tokens.get(i + 1).getStr().equals("include") && tokens.get(i + 2).getKind() == Token.Kind.TK_STRING) {
                String str = tokens.get(i + 2).getStr();
                tokens.remove(i + 2);
                tokens.remove(i + 1);
                tokens.remove(i);
                if (!this.set.contains(str)) {
                    this.set.add(str);
                    String lib = FileUtils.loadFile(str.substring(1, str.length() - 1));
                    tokens.addAll(i, Tokenizer.tokenize(lib));
                    changed = true;
                }
                --i;
            }
            ++i;
        }
        return changed;
    }
}

