/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program.compiler;

public class CompileException
extends Exception {
    private static final long serialVersionUID = -7191770397398568501L;
    private final int at;

    CompileException(String msg, int at) {
        super(msg);
        this.at = at;
    }

    public String getDetailMessage(String source) {
        int count = 0;
        int rowStart = 0;
        int row = 1;
        int col = 1;
        while (count < this.at) {
            if (source.charAt(count++) == '\n') {
                rowStart = count;
                ++row;
                col = 1;
                continue;
            }
            ++col;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage());
        sb.append("\nat row ");
        sb.append(row);
        sb.append(", col ");
        sb.append(col);
        sb.append("\n");
        while (rowStart < source.length() && source.charAt(rowStart) != '\n') {
            sb.append(source.charAt(rowStart++));
        }
        return sb.toString();
    }
}

