/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.program;

import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.program.node.AryDecNode;
import net.comp_lot.craftalos.program.node.FunDecNode;
import net.comp_lot.craftalos.program.node.VarDecNode;
import net.comp_lot.craftalos.system.program.ProgramBlockConvertible;

public abstract class ProgramNode
implements ProgramBlockConvertible {
    private final ProgramNode parent;
    private final int srcAt;

    protected ProgramNode(ProgramNode parent, int srcAt) {
        this.parent = parent;
        this.srcAt = srcAt;
    }

    protected final ProgramNode getParent() {
        return this.parent;
    }

    public int getSrcAt() {
        return this.srcAt;
    }

    public VarDecNode getVariable(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (this.parent == null) {
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorVariableNotFound(ident), srcAt);
        }
        return this.parent.getVariable(ident, srcAt);
    }

    protected AryDecNode getArray(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (this.parent == null) {
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorArrayNotFound(ident), srcAt);
        }
        return this.parent.getArray(ident, srcAt);
    }

    protected FunDecNode getFunction(String ident, int srcAt) throws MachineProgram.ProgramException {
        if (this.parent == null) {
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorFunctionNotFound(ident), srcAt);
        }
        return this.parent.getFunction(ident, srcAt);
    }

    public final Result execute() throws MachineProgram.ProgramException {
        VarDecNode nodeExecute = this.getVariable("#node execute", -1);
        int remain = (int)nodeExecute.getValue();
        if (remain == 0) {
            throw new MachineProgram.ProgramException(StringManager.lang.runtimeErrorTooManyExecution(), this.getSrcAt());
        }
        nodeExecute.setValue(remain - 1);
        return this.run();
    }

    protected abstract Result run() throws MachineProgram.ProgramException;

    public abstract ProgramNode clone(ProgramNode var1);

    protected ProgramNode copy(ProgramNode original) {
        return this;
    }

    public static final class Result {
        private final boolean isReturn;
        private final double value;

        private Result(boolean isReturn, double value) {
            this.isReturn = isReturn;
            this.value = !Double.isNaN(value) ? value : 0.0;
        }

        public static Result getReturnResult(double value) {
            return new Result(true, value);
        }

        public static Result getNormalResult(double value) {
            return new Result(false, value);
        }

        public boolean isReturn() {
            return this.isReturn;
        }

        public double getValue() {
            return this.value;
        }
    }
}

