/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.phisics;

import net.comp_lot.craftalos.phisics.TouchConstraint;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.utils.TouchInfo;

public class TouchTestResult {
    private final TouchInfo touch;

    public WorldObject getObjectA() {
        return (WorldObject)this.touch.getShapeA().getOwner();
    }

    public WorldObject getObjectB() {
        return (WorldObject)this.touch.getShapeB().getOwner();
    }

    public Shape getShapeA() {
        return this.touch.getShapeA();
    }

    public Shape getShapeB() {
        return this.touch.getShapeB();
    }

    public Vector getVec() {
        return this.touch.getVec();
    }

    public Vector getPos() {
        return this.touch.getPos();
    }

    TouchTestResult(TouchInfo touch) {
        this.touch = touch;
    }

    public TouchTestResult getRevClone() {
        return new TouchTestResult(new TouchInfo(new MutVector().set(this.getPos()), new MutVector().set(this.getVec()).reverse(), this.touch.getShapeB(), this.touch.getShapeA()));
    }

    public TouchTestResult clone() {
        return new TouchTestResult(new TouchInfo(new MutVector().set(this.getPos()), new MutVector().set(this.getVec()), this.touch.getShapeA(), this.touch.getShapeB()));
    }

    private double getDepth(boolean domestic) {
        double depth = this.getVec().getSize();
        if (domestic) {
            if (depth < 0.05) {
                depth = -1.0;
            } else if (depth < 0.1) {
                depth = (depth - 0.05) * 2.0;
            }
        }
        return depth;
    }

    TouchConstraint getTouchConstraint(boolean domestic) {
        double depth = this.getDepth(domestic);
        if (depth < 0.0) {
            return null;
        }
        this.touch.resize(1.0);
        Vector n = this.getVec();
        Vector vVA = this.getObjectA().getMove(this.getPos());
        Vector vVB = this.getObjectB().getMove(this.getPos());
        MutVector rv = new MutVector().set(vVB, vVA);
        double relative = Vector.Dot(rv, n);
        if (relative > 0.005) {
            return null;
        }
        double dv = -0.5 * relative;
        double d = TouchTestResult.getPenaltySpeed(depth);
        int n2 = domestic ? 2 : 1;
        if (dv < d * (double)n2) {
            dv = TouchTestResult.getPenaltySpeed(depth) * (double)(domestic ? 2 : 1);
        }
        rv.toOrthogonal(n);
        TouchConstraint c = new TouchConstraint(this, rv.getSize() < 0.25, dv, domestic);
        return c;
    }

    private static double getPenaltySpeed(double depth) {
        return depth * 0.45 + depth * depth * 0.3;
    }
}

