/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.phisics;

import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.phisics.CalculatingForce;
import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.TouchTestResult;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Shape;

class TouchConstraint {
    private final Vector pos;
    final Vector vec;
    final PhysicsObject objectA;
    final WorldObject objectB;
    private final Shape shapeA;
    private final Shape shapeB;
    final boolean isStatic;
    final double dvObjective;
    final double fakeWeight;
    final boolean domestic;
    private final boolean rev;
    private final CalculatingForce force;

    TouchConstraint(TouchTestResult r, boolean isStatic, double dvObjective, boolean domestic) {
        this.pos = r.getPos();
        this.vec = r.getVec();
        this.objectA = (PhysicsObject)r.getObjectA();
        this.objectB = r.getObjectB();
        this.shapeA = r.getShapeA();
        this.shapeB = r.getShapeB();
        this.isStatic = isStatic;
        this.dvObjective = dvObjective;
        this.domestic = domestic;
        this.fakeWeight = this.calcFakeWeight(r.getVec());
        this.rev = false;
        this.force = new CalculatingForce(this.vec);
    }

    private TouchConstraint(TouchConstraint rev) {
        this.pos = rev.pos;
        this.vec = new MutVector().set(rev.vec).reverse();
        this.objectA = (PhysicsObject)rev.objectB;
        this.objectB = rev.objectA;
        this.shapeA = rev.shapeB;
        this.shapeB = rev.shapeA;
        this.isStatic = rev.isStatic;
        this.dvObjective = rev.dvObjective;
        this.domestic = rev.domestic;
        this.fakeWeight = rev.fakeWeight;
        this.rev = true;
        this.force = rev.force;
    }

    TouchConstraint rev() {
        return new TouchConstraint(this);
    }

    MutVector getRelative() {
        return new MutVector().set(this.objectB.getMove(this.pos), this.objectA.getMove(this.pos));
    }

    MutVector getNewRelative() {
        return new MutVector().set(this.objectB.getNewMove(this.pos), this.objectA.getNewMove(this.pos));
    }

    void addForce(Vector nForce, Vector fForce) {
        this.force.addForce(nForce, fForce, this.isStatic ? 0.9 : 0.4, this.rev);
    }

    void addForce() {
        if (!this.force.isEnable()) {
            return;
        }
        if (this.rev) {
            if (this.domestic) {
                ((PhysicsObject)this.objectB).addForce(this.force.getForce(this.pos));
            }
            this.objectA.addForce(this.force.getRevForce(this.pos));
        } else {
            if (this.domestic) {
                ((PhysicsObject)this.objectB).addForce(this.force.getRevForce(this.pos));
            }
            this.objectA.addForce(this.force.getForce(this.pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void causeDamage(EntityParent entities) {
        double damage;
        if (this.rev) {
            return;
        }
        MutVector rvv = this.getRelative();
        MutVector dvv = new MutVector().set(rvv, this.getNewRelative());
        double f = this.force.getNormalForce().getSize();
        double dv = Vector.Dot(dvv, this.vec);
        double rvo = rvv.toOrthogonal(this.vec).getSize();
        double p = f * dv * dv;
        if (p * 0.1 > 0.5) {
            Sound s = new Sound(SoundEnum.CLASH, this.pos, (float)Math.min(p * 0.1 - 0.5, 1.0));
            EntityParent entityParent = entities;
            synchronized (entityParent) {
                entities.add(s);
            }
        }
        if ((damage = (p * 0.15 + f * rvo * 0.15 - 30.0) * 1.25) > 10.0) {
            if (this.objectA instanceof Part) {
                ((Part)this.objectA).getMachine().damage(damage * 0.5);
                ((Part)this.objectA).getBlockByShape(this.shapeA).damagePropagation(damage * 0.5);
            }
            if (this.objectB instanceof Part) {
                ((Part)this.objectB).getMachine().damage(damage * 0.5);
                ((Part)this.objectB).getBlockByShape(this.shapeB).damagePropagation(damage * 0.5);
            }
        }
    }

    double calcFakeWeight(Vector force) {
        return this.calcFakeWeight(new Force(this.pos, force));
    }

    private double calcFakeWeight(Force force) {
        double fa = 0.0;
        double fb = 0.0;
        fa = 1.0 / this.objectA.getFakeWeight(force);
        if (this.objectB.isPhysically()) {
            fb = 1.0 / ((PhysicsObject)this.objectB).getFakeWeight(force);
        }
        return 1.0 / (fa + fb);
    }
}

